/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql.spy;

import com.caucho.sql.DriverConfig;
import com.caucho.sql.spy.SpyDataSource;
import com.caucho.sql.spy.SpyPreparedStatement;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SpyConnection
implements Connection {
    protected static final Logger log = Logger.getLogger(SpyConnection.class.getName());
    protected static final Logger logXA = Logger.getLogger(SpyConnection.class.getName() + ".XA");
    protected static final L10N L = new L10N(SpyConnection.class);
    private SpyDataSource _spyDataSource;
    private String _id;
    private int _stmtIdCount;
    private Connection _conn;

    public SpyConnection(Connection conn, SpyDataSource spyDataSource, DriverConfig driver) {
        this._spyDataSource = spyDataSource;
        this._conn = conn;
        this._id = this._spyDataSource.createConnectionId(driver);
    }

    public SpyConnection(Connection conn, SpyDataSource spyDataSource, String id) {
        this._spyDataSource = spyDataSource;
        this._conn = conn;
        this._id = id;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public String getId() {
        return this._id;
    }

    public String createStatementId() {
        return this.getId() + "." + this._stmtIdCount++;
    }

    @Override
    public String getCatalog() throws SQLException {
        try {
            String catalog = this._conn.getCatalog();
            log.fine(this.getId() + ":getCatalog() -> " + catalog);
            return catalog;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getCatalog(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            log.fine(this.getId() + ":setCatalog(" + catalog + ")");
            this._conn.setCatalog(catalog);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setCatalog(" + e + ")");
            throw e;
        }
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            DatabaseMetaData metaData = this._conn.getMetaData();
            String ident = metaData.getClass().getName();
            log.fine(this.getId() + ":getMetaData() -> " + ident);
            return metaData;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getMetaData(" + e + ")");
            throw e;
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            Map<String, Class<?>> map = this._conn.getTypeMap();
            log.fine(this.getId() + ":getTypeMap() -> " + map);
            return map;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getTypeMap(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            log.fine(this.getId() + ":setTypeMap(" + map + ")");
            this._conn.setTypeMap(map);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setTypeMap(" + e + ")");
            throw e;
        }
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        try {
            String nativeSQL = this._conn.nativeSQL(sql);
            log.fine(this.getId() + ":nativeSQL() -> " + nativeSQL);
            return nativeSQL;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-nativeSQL(" + e + ")");
            throw e;
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        try {
            int isolation = this._conn.getTransactionIsolation();
            log.fine(this.getId() + ":getTransactionIsolation() -> " + isolation);
            return isolation;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getTransactionIsolation(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setTransactionIsolation(int isolation) throws SQLException {
        try {
            log.fine(this.getId() + ":setTransactionIsolation(" + isolation + ")");
            this._conn.setTransactionIsolation(isolation);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setTransactionIsolation(" + e + ")");
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            SQLWarning warning = this._conn.getWarnings();
            log.fine(this.getId() + ":getWarnings() -> " + warning);
            return warning;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getWarnings(" + e + ")");
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            log.fine(this.getId() + ":clearWarnings()");
            this._conn.clearWarnings();
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-clearWarnings(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            log.fine(this.getId() + ":setReadOnly(" + readOnly + ")");
            this._conn.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setReadOnly(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            boolean isReadOnly = this._conn.isReadOnly();
            log.fine(this.getId() + "isReadOnly() -> " + isReadOnly);
            return isReadOnly;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-isReadOnly(" + e + ")");
            throw e;
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":createStatement()");
            }
            Statement stmt = this._conn.createStatement();
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":createStatement(type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency);
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":createStatement(type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ",holdability=" + resultSetHoldability + ")");
            }
            Statement stmt = this._conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
            return new SpyStatement(stmtId, this, stmt);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":prepareStatement(" + sql + ")");
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":prepareStatement(" + sql + ",type=" + resultSetType + ")");
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            String stmtId = null;
            if (log.isLoggable(Level.FINE)) {
                stmtId = this.createStatementId();
                log.fine(stmtId + ":prepareStatement(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
            return new SpyPreparedStatement(stmtId, this, stmt, sql);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}:prepareStatement({1}, resultSetType={2}, resultSetConcurrency={3}, resultSetHoldability={4})", (Object)this.getId(), (Object)sql, (Object)resultSetType, (Object)resultSetConcurrency, (Object)resultSetHoldability));
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (int i : columnIndexes) {
                    list.add(i);
                }
                log.fine(L.l("{0}:prepareStatement({1}, columnIndexes={2})", (Object)this.getId(), (Object)sql, list));
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, columnIndexes);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(L.l("{0}:prepareStatement({1}, columnNames={2})", (Object)this.getId(), (Object)sql, Arrays.asList(columnNames)));
            }
            PreparedStatement stmt = this._conn.prepareStatement(sql, columnNames);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareStatement(" + e + ")");
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":prepareCall(" + sql + ")");
            }
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareCall(" + e + ")");
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":prepareCall(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            CallableStatement stmt = this._conn.prepareCall(sql);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareCall(" + e + ")");
            throw e;
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this.getId() + ":prepareCall(" + sql + ",type=" + resultSetType + ",concurrency=" + resultSetConcurrency + ")");
            }
            CallableStatement stmt = this._conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
            return stmt;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-prepareCall(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        try {
            boolean autoCommit = this._conn.getAutoCommit();
            log.fine(this.getId() + ":getAutoCommit() -> " + autoCommit);
            return autoCommit;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getAutoCommit(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            logXA.fine(this.getId() + ":setAutoCommit(" + autoCommit + ")");
            this._conn.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            logXA.fine(this.getId() + ":exn-setAutoCommit(" + e + ")");
            throw e;
        }
    }

    @Override
    public void commit() throws SQLException {
        long start = this.start();
        try {
            this._conn.commit();
            if (logXA.isLoggable(Level.FINE)) {
                this.logXA(start, "commit()");
            }
        }
        catch (SQLException e) {
            this.logXA(start, "exn-commit(" + e + ")");
            throw e;
        }
    }

    @Override
    public void rollback() throws SQLException {
        long start = this.start();
        try {
            this._conn.rollback();
            if (logXA.isLoggable(Level.FINE)) {
                this.logXA(start, "rollback()");
            }
        }
        catch (SQLException e) {
            this.logXA(start, "exn-rollback(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        try {
            boolean isClosed = this._conn.isClosed();
            log.fine(this.getId() + ":isClosed() -> " + isClosed);
            return isClosed;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-isClosed(" + e + ")");
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        long start = this.start();
        try {
            this._conn.close();
            this.log(start, "close()");
        }
        catch (SQLException e) {
            this.log(start, "exn-close(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setHoldability(int hold) throws SQLException {
        log.fine(this.getId() + ":setHoldability(" + hold + ")");
        try {
            this._conn.setHoldability(hold);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setHoldability(" + e + ")");
            throw e;
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            int holdability = this._conn.getHoldability();
            log.fine(this.getId() + ":getHoldability() -> " + holdability);
            return holdability;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getHoldability(" + e + ")");
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        log.fine(this.getId() + ":setSavepoint()");
        try {
            return this._conn.setSavepoint();
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setSavepoint(" + e + ")");
            throw e;
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        log.fine(this.getId() + ":setSavepoint(" + name + ")");
        try {
            return this._conn.setSavepoint(name);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-setSavepoint(" + e + ")");
            throw e;
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        log.fine(this.getId() + ":releaseSavepoint(" + savepoint + ")");
        try {
            this._conn.releaseSavepoint(savepoint);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-releaseSavepoint(" + e + ")");
            throw e;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        log.fine(this.getId() + ":rollback(" + savepoint + ")");
        try {
            this._conn.rollback(savepoint);
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-rollback(" + e + ")");
            throw e;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            Clob clob = this._conn.createClob();
            log.fine(this.getId() + ":createClob() -> " + clob);
            return clob;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createClob(" + e + ")");
            throw e;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            Blob blob = this._conn.createBlob();
            log.fine(this.getId() + ":createBlob() -> " + blob);
            return blob;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createBlob(" + e + ")");
            throw e;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            NClob nclob = this._conn.createNClob();
            log.fine(this.getId() + ":createNClob() -> " + nclob);
            return nclob;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createNClob(" + e + ")");
            throw e;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            SQLXML xml = this._conn.createSQLXML();
            log.fine(this.getId() + ":createSQLXML() -> " + xml);
            return xml;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createSQLXML(" + e + ")");
            throw e;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            Array array = this._conn.createArrayOf(typeName, elements);
            log.fine(this.getId() + ":createArrayOf(typeName=" + typeName + ", elements=" + Arrays.asList(elements) + ") -> " + array);
            return array;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createArrayOf(" + e + ")");
            throw e;
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            Struct struct = this._conn.createStruct(typeName, attributes);
            log.fine(this.getId() + ":createStruct(typeName=" + typeName + ", attributes=" + Arrays.asList(attributes) + ") -> " + struct);
            return struct;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-createStruct(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            boolean valid = this._conn.isValid(timeout);
            log.fine(this.getId() + ":isValid(" + timeout + ") -> " + valid);
            return valid;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-isValid(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        log.fine(this.getId() + ":setClientInfo(" + name + "=" + value + ")");
        try {
            this._conn.setClientInfo(name, value);
        }
        catch (SQLClientInfoException e) {
            log.fine(this.getId() + ":exn-setClientInfo(" + e + ")");
            throw e;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            log.fine(this.getId() + ":setClientInfo(" + properties + ")");
            this._conn.setClientInfo(properties);
        }
        catch (SQLClientInfoException e) {
            log.fine(this.getId() + ":exn-setClientInfo(" + e + ")");
            throw e;
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        try {
            String value = this._conn.getClientInfo(name);
            log.fine(this.getId() + ":getClientInfo(" + name + ") -> " + value);
            return value;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":getClientInfo");
            throw e;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            Properties clientInfo = this._conn.getClientInfo();
            log.fine(this.getId() + ":getClientInfo() -> " + clientInfo);
            return clientInfo;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-getClientInfo(" + e + ")");
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            T t = this._conn.unwrap(iface);
            log.fine(this.getId() + ":unwrap(" + iface + ") -> " + t);
            return t;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-unwrap(" + e + ")");
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        try {
            boolean isWrapper = this._conn.isWrapperFor(iface);
            return isWrapper;
        }
        catch (SQLException e) {
            log.fine(this.getId() + ":exn-isWrapperFor(" + e + ")");
            throw e;
        }
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
    }

    protected long start() {
        return CurrentTime.getExactTime();
    }

    protected void logXA(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        logXA.fine("[" + delta + "ms] " + this.getId() + ":" + msg);
    }

    protected void log(long start, String msg) {
        long delta = CurrentTime.getExactTime() - start;
        log.fine("[" + delta + "ms] " + this.getId() + ":" + msg);
    }

    public String toString() {
        return "SpyConnection[id=" + this.getId() + ",conn=" + this._conn + "]";
    }
}

