/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.env.meter.ActiveTimeSensor;
import com.caucho.sql.UserConnection;
import com.caucho.sql.spy.SpyStatement;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class UserStatement
implements Statement {
    protected static final L10N L = new L10N(UserStatement.class);
    protected UserConnection _conn;
    protected Statement _stmt;
    protected boolean _isPoolable = true;
    private final ActiveTimeSensor _timeProbe;

    UserStatement(UserConnection conn, Statement stmt) {
        this._conn = conn;
        this._stmt = stmt;
        this._timeProbe = conn.getTimeProbe();
    }

    @Override
    public void setPoolable(boolean poolable) {
        if (!poolable) {
            this._isPoolable = false;
        }
    }

    @Override
    public boolean isPoolable() {
        return this._isPoolable;
    }

    public Statement getStatement() {
        Statement stmt = this._stmt;
        if (stmt instanceof SpyStatement) {
            stmt = ((SpyStatement)stmt).getStatement();
        }
        return stmt;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        try {
            this._stmt.addBatch(sql);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this._stmt.cancel();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void clearBatch() throws SQLException {
        try {
            this._stmt.clearBatch();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            Statement stmt = this._stmt;
            if (stmt != null) {
                stmt.clearWarnings();
            }
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            Statement stmt = this._stmt;
            this._stmt = null;
            if (stmt != null) {
                this._conn.closeStatement(stmt);
                stmt.close();
            }
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            ResultSet resultSet = this._stmt.executeQuery(sql);
            return resultSet;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            int n = this._stmt.executeUpdate(sql);
            return n;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public int executeUpdate(String query, int resultType) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            int n = this._stmt.executeUpdate(query, resultType);
            return n;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public int executeUpdate(String query, int[] columns) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            int n = this._stmt.executeUpdate(query, columns);
            return n;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public int executeUpdate(String query, String[] columns) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            int n = this._stmt.executeUpdate(query, columns);
            return n;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            boolean bl = this._stmt.execute(sql);
            return bl;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public boolean execute(String query, int resultType) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            boolean bl = this._stmt.execute(query, resultType);
            return bl;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public boolean execute(String query, int[] columns) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            boolean bl = this._stmt.execute(query, columns);
            return bl;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public boolean execute(String query, String[] columns) throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            boolean bl = this._stmt.execute(query, columns);
            return bl;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        long startTime = this._timeProbe.start();
        if (this._stmt == null) {
            throw new SQLException(L.l("statement `{0}' appears to be closed", (Object)this));
        }
        try {
            int[] nArray = this._stmt.executeBatch();
            return nArray;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
        finally {
            this._timeProbe.end(startTime);
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this._stmt.getResultSet();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this._stmt.getUpdateCount();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            return this._stmt.getFetchDirection();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setFetchDirection(direction);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            return this._stmt.getFetchSize();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setFetchSize(rows);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this._stmt.getMaxFieldSize();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setMaxFieldSize(max);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this._stmt.getMaxRows();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setMaxRows(max);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this._stmt.getMoreResults();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this._stmt.getQueryTimeout();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setQueryTimeout(seconds);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this._stmt.getResultSetConcurrency();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this._stmt.getResultSetType();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            Statement stmt = this._stmt;
            if (stmt != null) {
                return stmt.getWarnings();
            }
            return null;
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setCursorName(name);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.setPoolable(false);
            this._stmt.setEscapeProcessing(enable);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public boolean getMoreResults(int count) throws SQLException {
        try {
            return this._stmt.getMoreResults(count);
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this._stmt.getGeneratedKeys();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this._stmt.getResultSetHoldability();
        }
        catch (RuntimeException e) {
            this.onRuntimeException(e);
            throw e;
        }
        catch (SQLException e) {
            this.onSqlException(e);
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this._stmt == null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        if (iface.isAssignableFrom(this._stmt.getClass())) {
            return (T)this._stmt;
        }
        return this._stmt.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return true;
        }
        if (iface.isAssignableFrom(this._stmt.getClass())) {
            return true;
        }
        return this._stmt.isWrapperFor(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    protected void onSqlException(SQLException e) {
        this.setPoolable(false);
        if (this._conn != null) {
            this._conn.setPingRequired();
        }
    }

    protected void onRuntimeException(RuntimeException e) {
        if (this._conn != null) {
            this._conn.killPool();
        }
    }

    protected void killPool() {
        if (this._conn != null) {
            this._conn.killPool();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._stmt + "]";
    }
}

