/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.sql;

import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.sql.DBPool;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public class DatabaseConfig {
    private static final EnvironmentLocal<ArrayList<DatabaseConfig>> _databaseDefault = new EnvironmentLocal();
    private ContainerProgram _program = new ContainerProgram();

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public ConfigProgram getBuilderProgram() {
        return this._program;
    }

    @PostConstruct
    public void init() {
        ArrayList<DatabaseConfig> defaultList = (ArrayList<DatabaseConfig>)_databaseDefault.getLevel();
        if (defaultList == null) {
            defaultList = new ArrayList<DatabaseConfig>();
            _databaseDefault.set(defaultList);
        }
        defaultList.add(this);
    }

    static void configDefault(DBPool pool) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        DatabaseConfig.configDefault(pool, loader);
    }

    static void configDefault(DBPool pool, ClassLoader loader) {
        ArrayList defaultList;
        if (loader != null) {
            DatabaseConfig.configDefault(pool, loader.getParent());
        }
        if ((defaultList = (ArrayList)_databaseDefault.getLevel(loader)) != null) {
            for (int i = 0; i < defaultList.size(); ++i) {
                DatabaseConfig config = (DatabaseConfig)defaultList.get(i);
                config.getBuilderProgram().configure((Object)pool);
            }
        }
    }
}

