/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.servlets;

import com.caucho.VersionFactory;
import com.caucho.cloud.loadbalance.LoadBalanceBuilder;
import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.cloud.loadbalance.LoadBalanceService;
import com.caucho.config.types.Period;
import com.caucho.network.balance.ClientSocket;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.GenericServlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FastCGIServlet
extends GenericServlet {
    protected static final Logger log = Logger.getLogger(FastCGIServlet.class.getName());
    static final L10N L = new L10N(FastCGIServlet.class);
    private static final int FCGI_BEGIN_REQUEST = 1;
    private static final int FCGI_ABORT_REQUEST = 2;
    private static final int FCGI_END_REQUEST = 3;
    private static final int FCGI_PARAMS = 4;
    private static final int FCGI_STDIN = 5;
    private static final int FCGI_STDOUT = 6;
    private static final int FCGI_STDERR = 7;
    private static final int FCGI_DATA = 8;
    private static final int FCGI_GET_VALUES = 9;
    private static final int FCGI_GET_VALUES_RESULT = 10;
    private static final int FCGI_UNKNOWNE_TYPE = 11;
    private static final int FCGI_RESPONDER = 1;
    private static final int FCGI_AUTHORIZER = 2;
    private static final int FCGI_FILTER = 3;
    private static final int FCGI_VERSION = 1;
    private static final int FCGI_KEEP_CONN = 1;
    private static final int FCGI_REQUEST_COMPLETE = 0;
    private static final int FCGI_CANT_MPX_CONN = 1;
    private static final int FCGI_OVERLOADED = 2;
    private static final int FCGI_UNKNOWN_ROLE = 3;
    private int _servletId;
    private LoadBalanceBuilder _loadBalanceBuilder;
    private LoadBalanceManager _loadBalancer;
    private Path _pwd;
    private String _hostAddress;
    private InetAddress _hostAddr;
    private int _hostPort;
    protected QDate _calendar = new QDate();
    private long _readTimeout = 120000L;
    private int _maxKeepaliveCount = 250;
    private long _keepaliveTimeout = 15000L;
    private int _idCount = 0;

    public FastCGIServlet() {
        LoadBalanceService loadBalanceService = LoadBalanceService.getCurrent();
        if (loadBalanceService == null) {
            throw new IllegalStateException(L.l("'{0}' requires an active {1}", (Object)this, (Object)LoadBalanceService.class.getSimpleName()));
        }
        this._loadBalanceBuilder = loadBalanceService.createBuilder();
        this._loadBalanceBuilder.setMeterCategory("Resin|FastCGI");
    }

    public void addAddress(String address) {
        this._loadBalanceBuilder.addAddress(address);
    }

    public void setServerAddress(String address) {
        this.addAddress(address);
    }

    public void setFailRecoverTime(Period period) {
    }

    public void setMaxKeepalive(int max) {
        this._maxKeepaliveCount = max;
    }

    public void setKeepaliveTimeout(Period period) {
        this._keepaliveTimeout = period.getPeriod();
    }

    public void setReadTimeout(Period timeout) {
        this._readTimeout = timeout.getPeriod();
    }

    public void init(WebApp webApp) throws ServletException {
        this.init();
    }

    public void init() throws ServletException {
        this._pwd = Vfs.lookup();
        String serverAddress = this.getInitParameter("server-address");
        if (serverAddress != null) {
            this.addAddress(serverAddress);
        }
        this._loadBalancer = this._loadBalanceBuilder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        ServletOutputStream out = res.getOutputStream();
        String sessionId = null;
        ClientSocket stream = this._loadBalancer.openSticky(sessionId, request, null);
        boolean isValid = false;
        if (stream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine((Object)((Object)this) + " cannot open a stream from " + this._loadBalancer);
            }
            res.sendError(503);
            return;
        }
        try {
            boolean isKeepalive = true;
            long startRequestTime = CurrentTime.getCurrentTime();
            if (this.handleRequest(req, res, stream, (OutputStream)out, isKeepalive)) {
                stream.free(startRequestTime);
                stream = null;
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private boolean handleRequest(HttpServletRequest req, HttpServletResponse res, ClientSocket stream, OutputStream out, boolean keepalive) throws ServletException, IOException {
        int sublen;
        ReadStream rs = stream.getInputStream();
        WriteStream ws = stream.getOutputStream();
        this.writeHeader(ws, 1, 8);
        int role = 1;
        ws.write(role >> 8);
        ws.write(role);
        ws.write(keepalive ? 1 : 0);
        for (int i = 0; i < 5; ++i) {
            ws.write(0);
        }
        this.setEnvironment(stream, ws, req);
        ServletInputStream in = req.getInputStream();
        TempBuffer tempBuf = TempBuffer.allocate();
        byte[] buf = tempBuf.getBuffer();
        int len = buf.length;
        this.writeHeader(ws, 4, 0);
        boolean hasStdin = false;
        while ((sublen = in.read(buf, 0, len)) > 0) {
            hasStdin = true;
            this.writeHeader(ws, 5, sublen);
            ws.write(buf, 0, sublen);
        }
        TempBuffer.free((TempBuffer)tempBuf);
        tempBuf = null;
        this.writeHeader(ws, 5, 0);
        ws.flush();
        FastCGIInputStream is = new FastCGIInputStream(stream);
        int ch = this.parseHeaders(res, is);
        if (ch >= 0) {
            out.write(ch);
        }
        TempBuffer tb = TempBuffer.allocate();
        byte[] buffer = tb.getBuffer();
        while ((sublen = is.read(buffer, 0, buffer.length)) > 0) {
            out.write(buffer, 0, sublen);
        }
        TempBuffer.free((TempBuffer)tb);
        return !is.isDead() && keepalive;
    }

    private void setEnvironment(ClientSocket stream, WriteStream ws, HttpServletRequest req) throws IOException {
        this.addHeader(stream, ws, "REQUEST_URI", req.getRequestURI());
        this.addHeader(stream, ws, "REQUEST_METHOD", req.getMethod());
        this.addHeader(stream, ws, "SERVER_SOFTWARE", "Resin/" + VersionFactory.getVersion());
        this.addHeader(stream, ws, "SERVER_NAME", req.getServerName());
        this.addHeader(stream, ws, "SERVER_PORT", String.valueOf(req.getServerPort()));
        this.addHeader(stream, ws, "REMOTE_ADDR", req.getRemoteAddr());
        this.addHeader(stream, ws, "REMOTE_HOST", req.getRemoteAddr());
        if (req.getRemoteUser() != null) {
            this.addHeader(stream, ws, "REMOTE_USER", req.getRemoteUser());
        } else {
            this.addHeader(stream, ws, "REMOTE_USER", "");
        }
        if (req.getAuthType() != null) {
            this.addHeader(stream, ws, "AUTH_TYPE", req.getAuthType());
        }
        this.addHeader(stream, ws, "GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader(stream, ws, "SERVER_PROTOCOL", req.getProtocol());
        if (req.getQueryString() != null) {
            this.addHeader(stream, ws, "QUERY_STRING", req.getQueryString());
        } else {
            this.addHeader(stream, ws, "QUERY_STRING", "");
        }
        String scriptPath = req.getServletPath();
        String pathInfo = req.getPathInfo();
        WebApp webApp = (WebApp)req.getServletContext();
        Path appDir = webApp.getRootDirectory();
        String realPath = webApp.getRealPath(scriptPath);
        if (!appDir.lookup(realPath).isFile() && pathInfo != null) {
            scriptPath = scriptPath + pathInfo;
        }
        log.finer("STREAM file: " + webApp.getRealPath(scriptPath));
        this.addHeader(stream, ws, "PATH_INFO", req.getContextPath() + scriptPath);
        this.addHeader(stream, ws, "PATH_TRANSLATED", webApp.getRealPath(scriptPath));
        int contentLength = req.getContentLength();
        if (contentLength < 0) {
            this.addHeader(stream, ws, "CONTENT_LENGTH", "0");
        } else {
            this.addHeader(stream, ws, "CONTENT_LENGTH", String.valueOf(contentLength));
        }
        ServletContext rootContext = webApp.getContext("/");
        if (rootContext != null) {
            this.addHeader(stream, ws, "DOCUMENT_ROOT", rootContext.getRealPath("/"));
        }
        CharBuffer cb = new CharBuffer();
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = req.getHeader(key);
            if (key.equalsIgnoreCase("content-length")) {
                this.addHeader(stream, ws, "CONTENT_LENGTH", value);
                continue;
            }
            if (key.equalsIgnoreCase("content-type")) {
                this.addHeader(stream, ws, "CONTENT_TYPE", value);
                continue;
            }
            if (key.equalsIgnoreCase("if-modified-since") || key.equalsIgnoreCase("if-none-match") || key.equalsIgnoreCase("authorization") || key.equalsIgnoreCase("proxy-authorization")) continue;
            this.addHeader(stream, ws, this.convertHeader(cb, key), value);
        }
    }

    private CharBuffer convertHeader(CharBuffer cb, String key) {
        cb.clear();
        cb.append("HTTP_");
        for (int i = 0; i < key.length(); ++i) {
            char ch = key.charAt(i);
            if (ch == '-') {
                cb.append('_');
                continue;
            }
            if (ch >= 'a' && ch <= 'z') {
                cb.append((char)(ch + 65 - 97));
                continue;
            }
            cb.append(ch);
        }
        return cb;
    }

    private int parseHeaders(HttpServletResponse res, InputStream is) throws IOException {
        CharBuffer key = new CharBuffer();
        CharBuffer value = new CharBuffer();
        int ch = is.read();
        if (ch < 0) {
            log.fine("Can't contact FastCGI");
            res.sendError(404);
            return -1;
        }
        while (ch >= 0) {
            key.clear();
            value.clear();
            while (ch >= 0 && ch != 32 && ch != 13 && ch != 10 && ch != 58) {
                key.append((char)ch);
                ch = is.read();
            }
            while (ch >= 0 && ch == 32 || ch == 58) {
                ch = is.read();
            }
            while (ch >= 0 && ch != 13 && ch != 10) {
                value.append((char)ch);
                ch = is.read();
            }
            if (ch == 13 && (ch = is.read()) == 10) {
                ch = is.read();
            }
            if (key.length() == 0) {
                return ch;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine("fastcgi:" + key + ": " + value);
            }
            if (key.equalsIgnoreCase("status")) {
                char digit;
                int status = 0;
                int len = value.length();
                for (int i = 0; i < len && '0' <= (digit = value.charAt(i)) && digit <= '9'; ++i) {
                    status = 10 * status + digit - 48;
                }
                res.setStatus(status);
                continue;
            }
            if (key.startsWith("http") || key.startsWith("HTTP")) continue;
            if (key.equalsIgnoreCase("location")) {
                res.sendRedirect(value.toString());
                continue;
            }
            res.addHeader(key.toString(), value.toString());
        }
        return ch;
    }

    private void addHeader(ClientSocket stream, WriteStream ws, String key, String value) throws IOException {
        if (value == null) {
            return;
        }
        int keyLen = key.length();
        int valLen = value.length();
        int len = keyLen + valLen;
        len = keyLen < 128 ? ++len : (len += 4);
        len = valLen < 128 ? ++len : (len += 4);
        this.writeHeader(ws, 4, len);
        if (keyLen < 128) {
            ws.write(keyLen);
        } else {
            ws.write(0x80 | keyLen >> 24);
            ws.write(keyLen >> 16);
            ws.write(keyLen >> 8);
            ws.write(keyLen);
        }
        if (valLen < 128) {
            ws.write(valLen);
        } else {
            ws.write(0x80 | valLen >> 24);
            ws.write(valLen >> 16);
            ws.write(valLen >> 8);
            ws.write(valLen);
        }
        ws.print(key);
        ws.print(value);
    }

    private void addHeader(ClientSocket stream, WriteStream ws, CharBuffer key, String value) throws IOException {
        int keyLen = key.getLength();
        int valLen = value.length();
        int len = keyLen + valLen;
        len = keyLen < 128 ? ++len : (len += 4);
        len = valLen < 128 ? ++len : (len += 4);
        this.writeHeader(ws, 4, len);
        if (keyLen < 128) {
            ws.write(keyLen);
        } else {
            ws.write(0x80 | keyLen >> 24);
            ws.write(keyLen >> 16);
            ws.write(keyLen >> 8);
            ws.write(keyLen);
        }
        if (valLen < 128) {
            ws.write(valLen);
        } else {
            ws.write(0x80 | valLen >> 24);
            ws.write(valLen >> 16);
            ws.write(valLen >> 8);
            ws.write(valLen);
        }
        ws.print(key.getBuffer(), 0, keyLen);
        ws.print(value);
    }

    private void writeHeader(WriteStream ws, int type, int length) throws IOException {
        int id = 1;
        int pad = 0;
        ws.write(1);
        ws.write(type);
        ws.write(id >> 8);
        ws.write(id);
        ws.write(length >> 8);
        ws.write(length);
        ws.write(pad);
        ws.write(0);
    }

    public void destroy() {
        this._loadBalancer.close();
    }

    static class FastCGIInputStream
    extends InputStream {
        private ClientSocket _stream;
        private InputStream _is;
        private int _chunkLength;
        private int _padLength;
        private boolean _isDead;

        public FastCGIInputStream() {
        }

        public FastCGIInputStream(ClientSocket stream) {
            this.init(stream);
        }

        public void init(ClientSocket stream) {
            this._stream = stream;
            this._is = stream.getInputStream();
            this._chunkLength = 0;
            this._isDead = false;
        }

        public boolean isDead() {
            return this._isDead;
        }

        @Override
        public int read() throws IOException {
            do {
                if (this._chunkLength <= 0) continue;
                --this._chunkLength;
                return this._is.read();
            } while (this.readNext());
            return -1;
        }

        private boolean readNext() throws IOException {
            int version;
            if (this._is == null) {
                return false;
            }
            if (this._padLength > 0) {
                this._is.skip(this._padLength);
                this._padLength = 0;
            }
            block5: while ((version = this._is.read()) >= 0) {
                int type = this._is.read();
                int id = (this._is.read() << 8) + this._is.read();
                int length = (this._is.read() << 8) + this._is.read();
                int padding = this._is.read();
                this._is.read();
                switch (type) {
                    case 3: {
                        int appStatus = (this._is.read() << 24) + (this._is.read() << 16) + (this._is.read() << 8) + this._is.read();
                        int pStatus = this._is.read();
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this._stream + ": FCGI_END_REQUEST(appStatus:" + appStatus + ", pStatus:" + pStatus + ")");
                        }
                        if (appStatus != 0) {
                            this._isDead = true;
                        }
                        if (pStatus != 0) {
                            this._isDead = true;
                        }
                        this._is.skip(3L);
                        this._is = null;
                        return false;
                    }
                    case 6: {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this._stream + ": FCGI_STDOUT(length:" + length + ", padding:" + padding + ")");
                        }
                        if (length == 0) {
                            if (padding <= 0) continue block5;
                            this._is.skip(padding);
                            continue block5;
                        }
                        this._chunkLength = length;
                        this._padLength = padding;
                        return true;
                    }
                    case 7: {
                        if (log.isLoggable(Level.FINER)) {
                            log.finer(this._stream + ": FCGI_STDERR(length:" + length + ", padding:" + padding + ")");
                        }
                        byte[] buf = new byte[length];
                        this._is.read(buf, 0, length);
                        log.warning(new String(buf, 0, length));
                        if (padding <= 0) continue block5;
                        this._is.skip(padding);
                        continue block5;
                    }
                }
                log.warning(this._stream + ": Unknown Protocol(" + type + ")");
                this._isDead = true;
                this._is.skip(length + padding);
            }
            this._isDead = true;
            return false;
        }
    }
}

