/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webbeans;

import com.caucho.config.scope.AbstractScopeContext;
import com.caucho.config.scope.ContextContainer;
import com.caucho.inject.Module;
import com.caucho.inject.TransactionScoped;
import com.caucho.server.webbeans.XAContextContainer;
import com.caucho.transaction.TransactionImpl;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.transaction.Synchronization;

@Module
public class TransactionScope
extends AbstractScopeContext {
    private static final L10N L = new L10N(TransactionScope.class);
    private TransactionManagerImpl _xaManager = TransactionManagerImpl.getInstance();

    public boolean isActive() {
        return this._xaManager.getTransaction() != null;
    }

    public Class<? extends Annotation> getScope() {
        return TransactionScoped.class;
    }

    protected ContextContainer getContextContainer() {
        TransactionImpl xa = this._xaManager.getCurrent();
        if (xa == null || !xa.isActive()) {
            return null;
        }
        return (ContextContainer)xa.getResource((Object)"caucho.xa.scope");
    }

    protected ContextContainer createContextContainer() {
        TransactionImpl xa = this._xaManager.getCurrent();
        if (xa == null || !xa.isActive()) {
            return null;
        }
        XAContextContainer context = (XAContextContainer)((Object)xa.getResource((Object)"caucho.xa.scope"));
        if (context == null) {
            context = new XAContextContainer();
            xa.setAttribute("caucho.xa.scope", (Object)context);
            xa.registerSynchronization((Synchronization)context);
        }
        return context;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object result;
        TransactionImpl xa = this._xaManager.getCurrent();
        if (xa == null || !xa.isActive()) {
            throw new ContextNotActiveException(L.l("'{0}' cannot be created because @TransactionScoped requires an active transaction.", bean));
        }
        ScopeContext cxt = (ScopeContext)((Object)xa.getResource((Object)"caucho.xa.scope"));
        if (cxt == null) {
            cxt = new ScopeContext();
            xa.putResource((Object)"caucho.xa.scope", (Object)cxt);
            xa.registerSynchronization((Synchronization)cxt);
        }
        if ((result = cxt.get(bean)) != null || creationalContext == null) {
            return (T)result;
        }
        result = bean.create(creationalContext);
        Object id = null;
        cxt.put(bean, id, result, creationalContext);
        return (T)result;
    }

    static class ScopeContext
    extends ContextContainer
    implements Synchronization {
        ScopeContext() {
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.close();
        }
    }
}

