/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.types.PathBuilder;
import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployControllerType;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentListener;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppController;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WebAppSingleDeployGenerator
extends DeployGenerator<WebAppController>
implements EnvironmentListener {
    private static final L10N L = new L10N(WebAppSingleDeployGenerator.class);
    private static final Logger log = Logger.getLogger(WebAppSingleDeployGenerator.class.getName());
    private WebAppContainer _container;
    private WebAppController _parentWebApp;
    private String _urlPrefix = "";
    private Path _archivePath;
    private Path _rootDirectory;
    private ArrayList<WebAppConfig> _defaultList = new ArrayList();
    private WebAppConfig _config;
    private ClassLoader _parentLoader;
    private WebAppController _controller;

    public WebAppSingleDeployGenerator(DeployContainer<WebAppController> deployContainer) {
        super(deployContainer);
    }

    public WebAppSingleDeployGenerator(DeployContainer<WebAppController> deployContainer, WebAppContainer container, WebAppConfig config) {
        super(deployContainer);
        this.setContainer(container);
        String contextPath = config.getContextPath();
        if (contextPath.equals("/")) {
            contextPath = "";
        }
        this.setURLPrefix(config.getContextPath());
        this._config = config;
    }

    public WebAppContainer getContainer() {
        return this._container;
    }

    public void setContainer(WebAppContainer container) {
        this._container = container;
        if (this._parentLoader == null) {
            this._parentLoader = container.getClassLoader();
        }
    }

    public void setParentWebApp(WebAppController parent) {
        this._parentWebApp = parent;
    }

    public void setParentClassLoader(ClassLoader loader) {
        this._parentLoader = loader;
    }

    public void setURLPrefix(String prefix) {
        if (!prefix.startsWith("/")) {
            prefix = "/" + prefix;
        }
        while (prefix.endsWith("/")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        this._urlPrefix = prefix;
    }

    public String getURLPrefix() {
        return this._urlPrefix;
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
    }

    public void addWebAppDefault(WebAppConfig config) {
        this._defaultList.add(config);
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected void initImpl() {
        super.initImpl();
        if (this._controller != null) {
            return;
        }
        String rootDir = this._config.getRootDirectory();
        String archivePath = this._config.getArchivePath();
        if (archivePath != null) {
            this._archivePath = PathBuilder.lookupPath((String)archivePath, null, (Path)this._container.getRootDirectory());
        }
        if (this._rootDirectory == null) {
            if (rootDir == null) {
                if (this._archivePath != null && (this._urlPrefix.equals("/") || this._urlPrefix.equals("")) && this._container != null) {
                    log.warning(L.l("web-app's root-directory '{0}' must be outside of the '{1}' root-directory when using 'archive-path", (Object)this._rootDirectory, (Object)this._container));
                    rootDir = "./ROOT";
                } else {
                    rootDir = "./" + this._urlPrefix;
                }
            }
            this._rootDirectory = PathBuilder.lookupPath((String)rootDir, null, (Path)this._container.getDocumentDirectory());
        }
        this._controller = new WebAppController(this._rootDirectory, this._container, this._urlPrefix);
        this._controller.setArchivePath(this._archivePath);
        if (this._archivePath != null) {
            this._controller.addDepend(this._archivePath);
        }
        this._controller.setParentWebApp(this._parentWebApp);
        for (WebAppConfig config : this._defaultList) {
            this._controller.addConfigDefault(config);
        }
        this._controller.setConfig(this._config);
        this._controller.setPrologue(this._config.getPrologue());
        this._controller.setStartupPriority(this._config.getStartupPriority());
        this._controller.setSourceType("single");
        Environment.addEnvironmentListener((EnvironmentListener)this, (ClassLoader)this._parentLoader);
        if (!this.isDeployed()) {
            log.warning(this._controller + " does not have an active root-directory " + this._controller.getRootDirectory());
        }
    }

    @Override
    protected void fillDeployedNames(Set<String> keys) {
        if (!this.isDeployed()) {
            return;
        }
        if (this._controller != null) {
            keys.add(this._controller.getContextPath());
        }
    }

    private boolean isDeployed() {
        return this._controller != null;
    }

    @Override
    public void generateController(String name, ArrayList<WebAppController> list) {
        if (!this.isDeployed()) {
            return;
        }
        if (name.equals(this._controller.getContextPath())) {
            WebAppController webApp = new WebAppController(this._controller.getId(), this._rootDirectory, this._container, this._urlPrefix);
            webApp.setArchivePath(this._controller.getArchivePath());
            webApp.setStartupPriority(this._controller.getStartupPriority());
            webApp.merge(this._controller);
            webApp.setControllerType(DeployControllerType.STATIC);
            list.add(webApp);
        }
    }

    @Override
    public void mergeController(WebAppController controller, String name) {
        if (controller.getRootDirectory().equals((Object)this._controller.getRootDirectory()) || this._controller.isNameMatch(name)) {
            controller.setContextPath(this._controller.getContextPath());
            controller.setDynamicDeploy(false);
        } else if (!this._controller.isNameMatch(name)) {
            // empty if block
        }
    }

    public void deploy() {
        try {
            this.init();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    @Override
    public Throwable getConfigException() {
        Throwable configException = super.getConfigException();
        if (configException == null && this._controller != null) {
            configException = this._controller.getConfigException();
        }
        return configException;
    }

    @Override
    protected void destroyImpl() {
        Environment.removeEnvironmentListener((EnvironmentListener)this, (ClassLoader)this._parentLoader);
        this._container.removeWebAppDeploy(this);
        super.destroyImpl();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._urlPrefix + "]";
    }
}

