/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.config.ConfigException;
import com.caucho.config.types.PathBuilder;
import com.caucho.server.dispatch.UrlMap;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;

public class RewriteRealPath {
    static final L10N L = new L10N(RewriteRealPath.class);
    static final Logger log = Logger.getLogger(RewriteRealPath.class.getName());
    private Path _appDir;
    private final ArrayList<Program> _programList = new ArrayList();
    private UrlMap<String> _pathMapping;

    public RewriteRealPath(Path appDir) {
        this._appDir = appDir;
    }

    public void addRewrite(Rewrite rewrite) {
        this._programList.add(rewrite);
    }

    public void addRealPath(RealPath realPath) {
        this._programList.add(realPath);
    }

    public void addPathPattern(String urlPattern, String realPath) {
        if (this._pathMapping == null) {
            this._pathMapping = new UrlMap();
        }
        this._pathMapping.addMap(urlPattern, realPath);
    }

    public void addPathRegexp(String urlRegexp, String realPath) {
        if (this._pathMapping == null) {
            this._pathMapping = new UrlMap();
        }
        this._pathMapping.addRegexp(urlRegexp, realPath);
    }

    public String mapToRealPath(String uri) {
        for (int i = 0; i < this._programList.size(); ++i) {
            Program program = this._programList.get(i);
            String realPath = program.toRealPath(uri = program.rewrite(uri));
            if (realPath == null) continue;
            return this._appDir.lookup(realPath).getNativePath();
        }
        return this.pathMappingToRealPath(uri);
    }

    private String pathMappingToRealPath(String uri) {
        Path path;
        if (this._pathMapping == null) {
            return this._appDir.lookup("./" + uri).getNativePath();
        }
        ArrayList<String> regexpVars = new ArrayList<String>();
        String map = this._pathMapping.map(uri, regexpVars);
        if (map == null) {
            path = this._appDir.lookup("./" + uri);
        } else {
            try {
                path = PathBuilder.lookupPath((String)map, regexpVars);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                path = this._appDir.lookup(map);
            }
            String match = regexpVars.get(0);
            String tail = uri.substring(match.length());
            if (uri.endsWith("/") && !tail.endsWith("/")) {
                tail = tail + '/';
            }
            if (tail.startsWith("/")) {
                tail = '.' + tail;
            }
            if (!tail.equals("")) {
                path = path.lookup(tail);
            }
        }
        String nativePath = path.getNativePath();
        return nativePath;
    }

    public static class RealPath
    extends Program {
        private Pattern _regexp;
        private String _target;

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setTarget(String target) {
            StringBuilder sb = new StringBuilder();
            int length = target.length();
            for (int i = 0; i < length; ++i) {
                char ch1;
                char ch = target.charAt(i);
                if (ch == '\\' && i + 1 < length && ('0' > (ch1 = target.charAt(i + 1)) || ch1 > '9')) {
                    sb.append("\\\\");
                    continue;
                }
                sb.append(ch);
            }
            this._target = sb.toString();
        }

        @PostConstruct
        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("real-path needs 'regexp' attribute."));
            }
            if (this._target == null) {
                throw new ConfigException(L.l("real-path needs 'target' attribute."));
            }
        }

        @Override
        public String toRealPath(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                return matcher.replaceAll(this._target);
            }
            return null;
        }
    }

    public static class Rewrite
    extends Program {
        private Pattern _regexp;
        private String _replacement;

        public void setRegexp(String regexp) {
            this._regexp = Pattern.compile(regexp);
        }

        public void setReplacement(String replacement) {
            this._replacement = replacement;
        }

        @PostConstruct
        public void init() throws ConfigException {
            if (this._regexp == null) {
                throw new ConfigException(L.l("rewrite needs 'regexp' attribute."));
            }
            if (this._replacement == null) {
                throw new ConfigException(L.l("rewrite needs 'replacement' attribute."));
            }
        }

        @Override
        public String rewrite(String uri) {
            Matcher matcher = this._regexp.matcher(uri);
            if (matcher.find()) {
                matcher.reset();
                return matcher.replaceAll(this._replacement);
            }
            return uri;
        }
    }

    static class Program {
        Program() {
        }

        public String rewrite(String uri) {
            return uri;
        }

        public String toRealPath(String uri) {
            return null;
        }
    }
}

