/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.server.dispatch.Invocation;
import com.caucho.server.webapp.AbstractDispatchRequest;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.FreeList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

class IncludeDispatchRequest
extends AbstractDispatchRequest {
    protected static final Logger log = Logger.getLogger(IncludeDispatchRequest.class.getName());
    private static final FreeList<IncludeDispatchRequest> _freeList = new FreeList(32);
    private Hashtable<String, String> _headers;

    protected IncludeDispatchRequest() {
    }

    public static IncludeDispatchRequest createDispatch() {
        IncludeDispatchRequest req = (IncludeDispatchRequest)_freeList.allocate();
        if (req == null) {
            req = new IncludeDispatchRequest();
        }
        return req;
    }

    @Override
    void init(Invocation invocation, WebApp webApp, WebApp oldWebApp, HttpServletRequest request, HttpServletResponse response, String method, String uri, String servletPath, String pathInfo, String queryString, String addedQuery) throws ServletException {
        super.init(invocation, webApp, oldWebApp, request, response, method, uri, servletPath, pathInfo, queryString, addedQuery);
        this._headers = null;
    }

    @Override
    public Enumeration getHeaderNames() {
        return new HeaderEnumeration(super.getHeaderNames(), this._headers);
    }

    @Override
    public String getHeader(String key) {
        String value = null;
        if (this._headers != null) {
            value = this._headers.get(key);
        }
        if (value != null) {
            return value;
        }
        if (key.equalsIgnoreCase("If-Modified-Since") || key.equalsIgnoreCase("If-None-Match")) {
            return null;
        }
        return super.getHeader(key);
    }

    @Override
    public void setHeader(String key, String value) {
        if (this._headers == null) {
            this._headers = new Hashtable();
        }
        this._headers.put(key, value);
    }

    public static void free(IncludeDispatchRequest req) {
        req.free();
        _freeList.free((Object)req);
    }

    public static class HeaderEnumeration
    implements Enumeration {
        private Enumeration _parent;
        private Hashtable<String, String> _headers;
        private Iterator<String> _headerIter;
        private String _nextHeader;

        HeaderEnumeration(Enumeration parent, Hashtable<String, String> headers) {
            this._parent = parent;
            this._headers = headers;
            if (headers != null) {
                this._headerIter = headers.keySet().iterator();
            }
        }

        @Override
        public boolean hasMoreElements() {
            if (this._nextHeader != null) {
                return true;
            }
            if (this._parent == null && this._headerIter == null) {
                return false;
            }
            if (this._parent != null) {
                while (this._parent.hasMoreElements() && this._nextHeader == null) {
                    this._nextHeader = (String)this._parent.nextElement();
                    if (this._nextHeader == null || !this._nextHeader.equalsIgnoreCase("If-Modified-Since") && !this._nextHeader.equalsIgnoreCase("If-None-Match") && (this._headers == null || this._headers.get(this._nextHeader) == null)) continue;
                    this._nextHeader = null;
                }
                if (this._nextHeader == null) {
                    this._parent = null;
                } else {
                    return true;
                }
            }
            if (this._headerIter != null) {
                this._nextHeader = this._headerIter.next();
            }
            return this._nextHeader != null;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                return null;
            }
            String value = this._nextHeader;
            this._nextHeader = null;
            return value;
        }
    }
}

