/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.webapp;

import com.caucho.i18n.CharacterEncoding;
import com.caucho.server.dispatch.Invocation;
import com.caucho.server.http.CauchoRequest;
import com.caucho.server.http.CauchoResponse;
import com.caucho.server.http.Form;
import com.caucho.server.http.RequestAdapter;
import com.caucho.server.http.ServletInputStreamImpl;
import com.caucho.server.session.SessionImpl;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.CurrentTime;
import com.caucho.util.FreeList;
import com.caucho.util.HashMapImpl;
import com.caucho.vfs.BufferedReaderAdapter;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.ReadStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

class AbstractDispatchRequest
extends RequestAdapter {
    protected static final Logger log = Logger.getLogger(AbstractDispatchRequest.class.getName());
    private static final FreeList<AbstractDispatchRequest> _freeList = new FreeList(32);
    private WebApp _webApp;
    private WebApp _oldWebApp;
    private Invocation _invocation;
    private Form _formParser;
    private HashMapImpl<String, String[]> _form;
    protected ReadStream _readStream;
    protected ServletInputStreamImpl _is;
    private BufferedReaderAdapter _bufferedReader;
    private String _method;
    private String _uri;
    private String _servletPath;
    private String _pathInfo;
    private String _queryString;
    private String _addedQuery;
    private SessionImpl _session;
    private String _pageUri;
    private String _pageContextPath;
    private String _pageServletPath;
    private String _pagePathInfo;
    private String _pageQueryString;

    protected AbstractDispatchRequest() {
    }

    public static AbstractDispatchRequest createDispatch() {
        AbstractDispatchRequest req = (AbstractDispatchRequest)_freeList.allocate();
        if (req == null) {
            req = new AbstractDispatchRequest();
        }
        return req;
    }

    void init(Invocation invocation, WebApp webApp, WebApp oldWebApp, HttpServletRequest request, HttpServletResponse response, String method, String uri, String servletPath, String pathInfo, String queryString, String addedQuery) throws ServletException {
        super.init(request, response, webApp);
        this._invocation = invocation;
        this._webApp = webApp;
        this._oldWebApp = oldWebApp;
        this._form = null;
        this._readStream = null;
        this._is = null;
        this._bufferedReader = null;
        this._method = method;
        this._uri = uri;
        this._servletPath = servletPath;
        this._pathInfo = pathInfo;
        this._queryString = queryString;
        this._addedQuery = addedQuery;
        this._pageUri = null;
        this._pageContextPath = null;
        this._pageServletPath = null;
        this._pagePathInfo = null;
        this._pageQueryString = null;
        this._session = null;
    }

    void setStream(ReadStream readStream) {
        this._readStream = readStream;
    }

    @Override
    public WebApp getWebApp() {
        return this._webApp;
    }

    @Override
    public String getMethod() {
        return this._method;
    }

    @Override
    public String getRequestURI() {
        return this._uri;
    }

    @Override
    public StringBuffer getRequestURL() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getScheme());
        sb.append("://");
        sb.append(this.getServerName());
        if (this.getServerPort() > 0 && this.getServerPort() != 80 && this.getServerPort() != 443) {
            sb.append(":");
            sb.append(this.getServerPort());
        }
        sb.append(this.getRequestURI());
        return sb;
    }

    void setPageURI(String uri) {
        this._pageUri = uri;
    }

    @Override
    public String getPageURI() {
        return this._pageUri;
    }

    @Override
    public String getContextPath() {
        if (this._webApp != null) {
            return this._webApp.getContextPath();
        }
        return "/";
    }

    void setPageContextPath(String contextPath) {
        this._pageContextPath = contextPath;
    }

    @Override
    public String getPageContextPath() {
        return this._pageContextPath;
    }

    @Override
    public String getServletPath() {
        return this._servletPath;
    }

    @Override
    public String getPageServletPath() {
        return this._pageServletPath;
    }

    void setPageServletPath(String servletPath) {
        this._pageServletPath = servletPath;
    }

    @Override
    public String getPathInfo() {
        return this._pathInfo;
    }

    @Override
    public String getPagePathInfo() {
        return this._pagePathInfo;
    }

    void setPagePathInfo(String pathInfo) {
        this._pagePathInfo = pathInfo;
    }

    @Override
    public String getQueryString() {
        return this._queryString;
    }

    void setPageQueryString(String queryString) {
        this._pageQueryString = queryString;
    }

    @Override
    public String getPageQueryString() {
        return this._pageQueryString;
    }

    @Override
    public Map getParameterMap() {
        if (this._form == null) {
            this._form = this.parseQuery();
        }
        return this._form;
    }

    @Override
    public Enumeration getParameterNames() {
        if (this._form == null) {
            this._form = this.parseQuery();
        }
        return Collections.enumeration(this._form.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        if (this._form == null) {
            this._form = this.parseQuery();
        }
        return (String[])this._form.get((Object)name);
    }

    @Override
    public String getParameter(String name) {
        String[] values = this.getParameterValues(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    private HashMapImpl<String, String[]> parseQuery() {
        HashMapImpl table = new HashMapImpl();
        String defaultEncoding = CharacterEncoding.getLocalEncoding();
        String charEncoding = this.getCharacterEncoding();
        if (charEncoding == null) {
            charEncoding = defaultEncoding;
        }
        String javaEncoding = Encoding.getJavaName((String)charEncoding);
        if (this._addedQuery != null) {
            try {
                if (this._formParser == null) {
                    this._formParser = new Form();
                }
                this._formParser.parseQueryString((HashMapImpl<String, String[]>)table, this._addedQuery, javaEncoding, false);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        Enumeration en = super.getParameterNames();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String[] oldValues = super.getParameterValues(key);
            String[] newValues = (String[])table.get((Object)key);
            if (oldValues == null) continue;
            if (newValues == null) {
                table.put((Object)key, (Object)oldValues);
                continue;
            }
            String[] next = new String[oldValues.length + newValues.length];
            System.arraycopy(newValues, 0, next, 0, newValues.length);
            System.arraycopy(oldValues, 0, next, newValues.length, oldValues.length);
            table.put((Object)key, (Object)next);
        }
        return table;
    }

    @Override
    public String getRealPath(String path) {
        return this._webApp.getRealPath(path);
    }

    @Override
    public String getPathTranslated() {
        if (this._pathInfo != null) {
            return this.getRealPath(this._pathInfo);
        }
        return null;
    }

    @Override
    public RequestDispatcher getRequestDispatcher(String path) {
        if (path.startsWith("/")) {
            return this._webApp.getRequestDispatcher(path);
        }
        return this._webApp.getRequestDispatcher(this.getPwd() + path);
    }

    public String getPwd() {
        int p;
        String pathInfo;
        CharBuffer cb = CharBuffer.allocate();
        String servletPath = this.getPageServletPath();
        if (servletPath != null) {
            cb.append(servletPath);
        }
        if ((pathInfo = this.getPagePathInfo()) != null) {
            cb.append(pathInfo);
        }
        if ((p = cb.lastIndexOf('/')) >= 0) {
            cb.setLength(p);
        }
        cb.append('/');
        return cb.close();
    }

    @Override
    public ReadStream getStream() throws IOException {
        if (this._readStream == null && this.getRequest() instanceof CauchoRequest) {
            return ((CauchoRequest)this.getRequest()).getStream();
        }
        return this._readStream;
    }

    @Override
    public ServletInputStream getInputStream() throws IOException {
        if (this._readStream == null) {
            return super.getInputStream();
        }
        if (this._is == null) {
            this._is = new ServletInputStreamImpl();
        }
        this._is.init((InputStream)this._readStream);
        return this._is;
    }

    @Override
    public BufferedReader getReader() throws IOException {
        if (this._readStream == null) {
            return super.getReader();
        }
        if (this._bufferedReader == null) {
            this._bufferedReader = new BufferedReaderAdapter(this.getStream());
        }
        this._bufferedReader.init(this.getStream());
        return this._bufferedReader;
    }

    @Override
    public HttpSession getSession(boolean create) {
        SessionManager manager = null;
        if (this._webApp != null) {
            manager = this._webApp.getSessionManager();
        }
        if (manager != null) {
            this.setVaryCookie(manager.getCookieName());
        }
        if (this._session != null && this._session.isValid()) {
            this.setHasCookie();
            return this._session;
        }
        if (this._webApp == this._oldWebApp) {
            HttpSession hSession = super.getSession(create);
            if (hSession != null) {
                this.setHasCookie();
            }
            return hSession;
        }
        SessionImpl oldSession = this._session;
        this._session = this.createSession(create, oldSession != null);
        if (this._session != null) {
            this.setHasCookie();
        }
        return this._session;
    }

    private SessionImpl createSession(boolean create, boolean hasOldSession) {
        HttpServletResponse response;
        SessionImpl session;
        SessionManager manager = this.getSessionManager();
        String id = this.getRequestedSessionId();
        long now = CurrentTime.getCurrentTime();
        if (id != null && id.length() > 6) {
            session = manager.getSession(id, now, create, this.isRequestedSessionIdFromCookie());
            if (session != null && session.isValid()) {
                HttpServletResponse response2;
                if (session != null) {
                    this.setHasCookie();
                }
                if (!session.getId().equals(id) && manager.enableSessionCookies() && (response2 = this.getResponse()) instanceof CauchoResponse) {
                    ((CauchoResponse)this.getResponse()).setSessionId(session.getId());
                }
                return session;
            }
        } else {
            id = null;
        }
        if (!create) {
            return null;
        }
        session = manager.createSession(id, now, this, this.isRequestedSessionIdFromCookie());
        if (session != null) {
            this.setHasCookie();
        }
        if (session.getId().equals(id)) {
            return session;
        }
        if (manager.enableSessionCookies() && (response = this.getResponse()) instanceof CauchoResponse) {
            ((CauchoResponse)this.getResponse()).setSessionId(session.getId());
        }
        return session;
    }

    @Override
    public boolean isLoginRequested() {
        if (!(this.getRequest() instanceof CauchoRequest)) {
            return false;
        }
        return ((CauchoRequest)this.getRequest()).isLoginRequested();
    }

    @Override
    public boolean login(boolean isFail) {
        if (!(this.getRequest() instanceof CauchoRequest)) {
            return false;
        }
        return ((CauchoRequest)this.getRequest()).login(isFail);
    }

    @Override
    public boolean isUserInRole(String role) {
        String linkRole;
        HashMap<String, String> roleMap = this._invocation.getSecurityRoleMap();
        if (roleMap != null && (linkRole = roleMap.get(role)) != null) {
            role = linkRole;
        }
        return super.isUserInRole(role);
    }

    public void finishRequest() throws IOException {
        SessionImpl session = this._session;
        this._session = null;
        if (session != null) {
            session.finishRequest();
        }
    }

    public static void free(AbstractDispatchRequest req) {
        req.free();
        _freeList.free((Object)req);
    }

    @Override
    protected void free() {
        super.free();
        this._session = null;
        this._webApp = null;
        this._oldWebApp = null;
        this._readStream = null;
        this._invocation = null;
        if (this._is != null) {
            this._is.free();
        }
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getRequest() + "]";
    }
}

