/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.spdy;

import com.caucho.env.actor.AbstractActorProcessor;
import com.caucho.env.actor.ActorProcessor;
import com.caucho.env.actor.ActorQueue;
import com.caucho.server.spdy.SpdyConnection;
import com.caucho.server.spdy.SpdyStream;
import com.caucho.server.spdy.SpdyWriteItem;
import com.caucho.util.RingItem;
import com.caucho.util.RingItemFactory;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

class SpdyWriteActor
extends AbstractActorProcessor<SpdyWriteItem>
implements RingItemFactory<SpdyWriteItem> {
    private static final int VERSION = 3;
    private final SpdyConnection _conn;
    private final ActorQueue<SpdyWriteItem> _writeQueue;

    SpdyWriteActor(SpdyConnection conn) {
        this._conn = conn;
        this._writeQueue = new ActorQueue(256, (RingItemFactory)this, new ActorProcessor[]{this});
    }

    public String getThreadName() {
        return this._conn.getClass().getSimpleName() + '-' + Thread.currentThread().getId();
    }

    public void process(SpdyWriteItem item) throws Exception {
        int type = item.getType();
        switch (type) {
            case 2: {
                this.writeReply(item.getStream());
                break;
            }
            default: {
                this._conn.close();
            }
        }
        item.clear();
    }

    private void writeReply(SpdyStream stream) throws IOException {
        WriteStream os = this._conn.getWriteStream();
        os.write(128);
        os.write(3);
        os.write(0);
        os.write(2);
        int offset = os.getBufferOffset();
        int len = 8;
        this.writeInt(os, len);
        this.writeInt(os, stream.getClientId());
        this.writeInt(os, 0);
    }

    private void writeInt(WriteStream os, int value) throws IOException {
        os.write(value >> 24);
        os.write(value >> 16);
        os.write(value >> 8);
        os.write(value);
    }

    public void onProcessComplete() throws Exception {
        this._conn.getWriteStream().flush();
    }

    public SpdyWriteItem createItem(int index) {
        return new SpdyWriteItem(index);
    }

    public void writeStreamReply(SpdyStream stream) {
        SpdyWriteItem item = (SpdyWriteItem)this._writeQueue.startOffer(true);
        item.setType(2);
        item.setStream(stream);
        this._writeQueue.finishOffer((RingItem)item);
    }
}

