/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;

public class HashChunkOutputStream
extends OutputStream {
    private static final int FLAG_CLOSE = 32768;
    private static final int FLAG_CONT = 0;
    private OutputStream _next;
    private CRC32 _crc = new CRC32();
    private TempBuffer _tBuf;
    private byte[] _buffer;
    private int _offset;
    private int _end;

    public HashChunkOutputStream(OutputStream next) {
        this._next = next;
        this._tBuf = TempBuffer.allocate();
        this._buffer = this._tBuf.getBuffer();
        this._end = this._buffer.length - 4;
        this._offset = 2;
    }

    public long getDigest() {
        return this._crc.getValue();
    }

    @Override
    public void write(int data) throws IOException {
        int offset = this._offset;
        if (this._end <= offset) {
            offset = this.flushBuffer(offset, 0);
        }
        this._buffer[offset++] = (byte)data;
        this._offset = offset;
    }

    @Override
    public void write(byte[] bufferWrite, int offsetWrite, int lengthWrite) throws IOException {
        int offset = this._offset;
        int end = this._end;
        byte[] buffer = this._buffer;
        while (lengthWrite > 0) {
            int sublen = Math.min(lengthWrite, end - offset);
            if (sublen > 0) {
                System.arraycopy(bufferWrite, offsetWrite, buffer, offset, sublen);
                offsetWrite += sublen;
                offset += sublen;
                lengthWrite -= sublen;
                continue;
            }
            offset = this.flushBuffer(offset, 0);
        }
        this._offset = offset;
    }

    @Override
    public void close() throws IOException {
        if (this._tBuf != null) {
            this._offset = this.flushBuffer(this._offset, 32768);
            this._buffer = null;
            this._tBuf.freeSelf();
            this._tBuf = null;
            this._next.close();
            this._next = null;
        }
    }

    private int flushBuffer(int offset, int flag) throws IOException {
        int len = offset + flag;
        byte[] buffer = this._buffer;
        buffer[0] = (byte)(len >> 8);
        buffer[1] = (byte)len;
        this._crc.update(buffer, 0, offset);
        long digest = this._crc.getValue();
        buffer[offset + 0] = (byte)(digest >> 24);
        buffer[offset + 1] = (byte)(digest >> 16);
        buffer[offset + 2] = (byte)(digest >> 8);
        buffer[offset + 3] = (byte)(digest >> 0);
        this._next.write(buffer, 0, offset + 4);
        return 2;
    }
}

