/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.session;

import java.io.IOException;
import java.io.OutputStream;

public class DebugOutputStream
extends OutputStream {
    private OutputStream _os;
    private int _offset;

    public DebugOutputStream(OutputStream os) {
        this._os = os;
        System.out.print("{{{");
    }

    @Override
    public void write(int ch) throws IOException {
        this._os.write(ch);
        System.out.print(Integer.toHexString(ch >> 4 & 0xF));
        System.out.print(Integer.toHexString(ch & 0xF));
        ++this._offset;
        if (this._offset % 32 == 0) {
            System.out.println();
        } else if (this._offset % 8 == 0) {
            System.out.print(" ");
        }
    }

    @Override
    public void flush() throws IOException {
        this._os.flush();
    }

    @Override
    public void close() throws IOException {
        this._os.close();
        System.out.println("}}}");
    }
}

