/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.L10N;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UserInRoleCondition
extends AbstractCondition {
    private static final L10N L = new L10N(UserInRoleCondition.class);
    private final String _role;
    private boolean _sendVary = true;

    public UserInRoleCondition(String role) {
        this._role = role;
    }

    @Override
    public String getTagName() {
        return "user-in-role";
    }

    public void setSendVary(boolean sendVary) {
        this._sendVary = sendVary;
    }

    @Override
    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        if (this._sendVary) {
            this.addHeaderValue(response, "Vary", "Cookie");
        } else {
            this.addHeaderValue(response, "Cache-Control", "private");
        }
        return request.isUserInRole(this._role);
    }
}

