/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.http.HttpServletRequestImpl;
import com.caucho.server.rewrite.ContinueMapFilterChain;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.SetRequestSecureFilterChain;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class SetFilterChain
extends ContinueMapFilterChain {
    private final Boolean _isRequestSecure;
    private final String _requestCharacterEncoding;
    private final String _responseContentType;
    private String _responseCharacterEncoding;

    public SetFilterChain(String uri, String queryString, FilterChain accept, FilterChainMapper nextFilterChainMapper, String requestCharacterEncoding, Boolean isRequestSecure, String responseCharacterEncoding, String responseContentType) {
        super(uri, queryString, accept, nextFilterChainMapper);
        this._requestCharacterEncoding = requestCharacterEncoding;
        this._isRequestSecure = isRequestSecure;
        this._responseCharacterEncoding = responseCharacterEncoding;
        this._responseContentType = responseContentType;
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        if (this._requestCharacterEncoding != null) {
            request.setCharacterEncoding(this._requestCharacterEncoding);
        }
        Object oldRequest = null;
        Object cauchoResponse = null;
        if (this._isRequestSecure != null) {
            if (request instanceof HttpServletRequestImpl) {
                HttpServletRequestImpl req = (HttpServletRequestImpl)request;
                req.setSecure(this._isRequestSecure);
            } else {
                SetRequestSecureFilterChain.SecureServletRequestWrapper cauchoRequest = new SetRequestSecureFilterChain.SecureServletRequestWrapper((HttpServletRequest)request, this._isRequestSecure);
                request = cauchoRequest;
                request.setCharacterEncoding(this._requestCharacterEncoding);
            }
        }
        if (this._responseCharacterEncoding != null) {
            response.setCharacterEncoding(this._responseCharacterEncoding);
        }
        if (this._responseContentType != null) {
            response.setContentType(this._responseContentType);
        }
        super.doFilter(request, response);
    }
}

