/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ExistsCondition
extends AbstractCondition {
    private static final L10N L = new L10N(ExistsCondition.class);
    private Path _pwd;
    private String _value;
    private Pattern _regexp;

    ExistsCondition(String value) {
        this._value = value;
        this._pwd = Vfs.lookup();
    }

    @Override
    public String getTagName() {
        return "exists";
    }

    public void setRegexp(Pattern pattern) {
        this._regexp = pattern;
    }

    @Override
    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        String servletPath = request.getServletPath();
        String realPath = request.getRealPath(servletPath);
        Path path = this._pwd.lookup(realPath);
        return path.canRead();
    }
}

