/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.server.rewrite.AbstractCondition;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CookieCondition
extends AbstractCondition {
    private String _name;
    private Pattern _regexp;
    private boolean _caseInsensitive;
    private boolean _sendVary = true;

    CookieCondition(String name) {
        this._name = name;
    }

    public void setCaseInsensitive(boolean caseInsensitive) {
        this._caseInsensitive = caseInsensitive;
    }

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public void setSendVary(boolean sendVary) {
        this._sendVary = sendVary;
    }

    @Override
    public String getTagName() {
        return "cookie";
    }

    @Override
    @PostConstruct
    public void init() {
        if (this._regexp != null && this._caseInsensitive) {
            this._regexp = Pattern.compile(this._regexp.pattern(), 2);
        }
    }

    @Override
    public boolean isMatch(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies;
        if (this._sendVary) {
            this.addHeaderValue(response, "Vary", "Cookie");
        }
        if ((cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                Cookie cookie = cookies[i];
                if (!cookie.getName().equals(this._name)) continue;
                return this._regexp == null || this._regexp.matcher(cookie.getValue()).find();
            }
        }
        return false;
    }
}

