/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.server.rewrite.AbstractRule;
import com.caucho.server.rewrite.AndConditions;
import com.caucho.server.rewrite.Condition;
import com.caucho.server.rewrite.ConditionConfig;
import com.caucho.server.rewrite.ConditionFilterChain;
import com.caucho.server.rewrite.ContinueMapFilterChain;
import com.caucho.server.rewrite.FilterChainMapper;
import com.caucho.server.rewrite.NotConditions;
import com.caucho.server.rewrite.OrConditions;
import com.caucho.server.rewrite.RewriteDispatch;
import com.caucho.util.L10N;
import com.caucho.vfs.CaseInsensitive;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class AbstractRuleWithConditions
extends AbstractRule {
    private static final L10N L = new L10N(AbstractRuleWithConditions.class);
    private static final Logger log = Logger.getLogger(AbstractRuleWithConditions.class.getName());
    private static final FilterChainNext NEXT = new FilterChainNext();
    private final boolean _isFiner;
    private final boolean _isFinest;
    private Pattern _regexp;
    private Pattern _urlRegexp;
    private ArrayList<Condition> _conditionList = new ArrayList();
    private Condition[] _conditions;

    protected AbstractRuleWithConditions(RewriteDispatch rewriteDispatch) {
        super(rewriteDispatch);
        this._isFinest = log.isLoggable(Level.FINEST);
        this._isFiner = log.isLoggable(Level.FINER);
    }

    public void setRegexp(Pattern regexp) {
        this._regexp = regexp;
    }

    public Pattern getRegexp() {
        return this._regexp;
    }

    public void setFullUrlRegexp(Pattern regexp) {
        this._urlRegexp = regexp;
    }

    public Pattern getFullUrlRegexp() {
        return this._urlRegexp;
    }

    public void addAnd(AndConditions condition) {
        this._conditionList.add(condition);
    }

    public void addOr(OrConditions condition) {
        this._conditionList.add(condition);
    }

    public void addNot(NotConditions condition) {
        this._conditionList.add(condition);
    }

    public void addWhen(ConditionConfig condition) {
        this._conditionList.add(condition.getCondition());
    }

    public void addUnless(ConditionConfig condition) {
        NotConditions not = new NotConditions();
        not.add(condition.getCondition());
        Config.init((Object)not);
        this._conditionList.add(not);
    }

    protected void required(Object value, String name) throws ConfigException {
        if (value == null) {
            throw new ConfigException(L.l("{0} requires '{1}' attribute.", (Object)this.getTagName(), (Object)name));
        }
    }

    @Override
    public void init() throws ConfigException {
        if (this._regexp != null) {
            this.setLogPrefix(this.getLogPrefix() + " " + this._regexp.pattern());
        }
        if (this._regexp != null && CaseInsensitive.isCaseInsensitive()) {
            this._regexp = Pattern.compile(this._regexp.pattern(), 2);
        }
        if (this._conditionList.size() > 0) {
            this._conditions = new Condition[this._conditionList.size()];
            this._conditionList.toArray(this._conditions);
        }
        this._conditionList = null;
        super.init();
    }

    @Override
    public FilterChain map(String uri, String queryString, FilterChain accept) throws ServletException {
        AbstractRuleWithConditions rule = this;
        while (rule != null) {
            FilterChain next = rule.mapImpl(uri, queryString, accept);
            if (next != NEXT) {
                return next;
            }
            FilterChainMapper nextRule = rule.getFailFilterChainMapper();
            if (nextRule instanceof AbstractRuleWithConditions) {
                rule = (AbstractRuleWithConditions)nextRule;
                continue;
            }
            return nextRule.map(uri, queryString, accept);
        }
        return null;
    }

    public FilterChain mapImpl(String uri, String queryString, FilterChain accept) throws ServletException {
        Matcher matcher;
        if (!this.isEnabled()) {
            if (this._isFinest) {
                log.finest(this.getLogPrefix() + " not enabled, no match");
            }
            return NEXT;
        }
        if (this._regexp != null) {
            matcher = this._regexp.matcher(uri);
            if (!matcher.find()) {
                if (this._isFinest) {
                    log.finest(this.getLogPrefix() + " does not match " + uri);
                }
                return NEXT;
            }
        } else if (this._urlRegexp != null) {
            String fullUrl = queryString != null ? uri + '?' + queryString : uri;
            matcher = this._urlRegexp.matcher(fullUrl);
            if (!matcher.find()) {
                return NEXT;
            }
        } else {
            matcher = null;
        }
        String targetUri = this.rewrite(uri, matcher);
        FilterChain ruleChain = this.dispatch(targetUri, queryString, accept, this.getPassFilterChainMapper());
        Condition[] conditions = this._conditions;
        if (conditions == null) {
            if (this._isFiner) {
                log.finer(this.getLogPrefix() + " '" + uri + "' --> '" + targetUri + "'");
            }
            if (ruleChain == null) {
                return this.getPassFilterChainMapper().map(uri, queryString, accept);
            }
            return ruleChain;
        }
        FilterChain passChain = ruleChain;
        if (passChain == null) {
            passChain = new ContinueMapFilterChain(targetUri, queryString, accept, this.getPassFilterChainMapper());
        }
        ContinueMapFilterChain failChain = new ContinueMapFilterChain(uri, queryString, accept, this.getFailFilterChainMapper());
        return new ConditionFilterChain(this.getLogPrefix(), uri, targetUri, conditions, passChain, failChain);
    }

    public String rewrite(String uri, Matcher matcher) {
        return uri;
    }

    public abstract FilterChain dispatch(String var1, String var2, FilterChain var3, FilterChainMapper var4) throws ServletException;

    @Override
    public void destroy() {
        Condition[] conditions = this._conditions;
        this._conditions = null;
        if (conditions != null) {
            for (Condition condition : conditions) {
                try {
                    condition.destroy();
                }
                catch (Exception ex) {
                    log.log(Level.FINER, ex.toString(), ex);
                }
            }
        }
        super.destroy();
    }

    static class FilterChainNext
    implements FilterChain {
        FilterChainNext() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }
    }
}

