/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.rewrite;

import com.caucho.config.Config;
import com.caucho.server.rewrite.AbstractCondition;
import com.caucho.server.rewrite.AndConditions;
import com.caucho.server.rewrite.Condition;
import com.caucho.server.rewrite.ConditionConfig;
import com.caucho.server.rewrite.NotConditions;
import com.caucho.server.rewrite.OrConditions;
import com.caucho.server.rewrite.RewriteDispatch;
import java.util.ArrayList;
import javax.annotation.PostConstruct;

public abstract class AbstractConditions
extends AbstractCondition {
    private final RewriteDispatch _rewriteDispatch;
    private ArrayList<Condition> _conditionsList = new ArrayList();
    private Condition[] _conditions;

    public AbstractConditions(RewriteDispatch rewriteDispatch) {
        this._rewriteDispatch = rewriteDispatch;
    }

    public <T extends Condition> T add(T condition) {
        this._conditionsList.add(condition);
        return condition;
    }

    public void addWhen(ConditionConfig condition) {
        this.add(condition.getCondition());
    }

    public void addUnless(ConditionConfig condition) {
        NotConditions not = new NotConditions();
        not.add(condition.getCondition());
        Config.init((Object)not);
        this.add(not);
    }

    public AndConditions createAnd() {
        return new AndConditions(this._rewriteDispatch);
    }

    public void addAnd(AndConditions and) {
        this.add(and);
    }

    public NotConditions createNot() {
        return new NotConditions(this._rewriteDispatch);
    }

    public void addNot(NotConditions not) {
        this.add(not);
    }

    public OrConditions createOr() {
        return new OrConditions(this._rewriteDispatch);
    }

    public void addOr(OrConditions or) {
        this.add(or);
    }

    @Override
    @PostConstruct
    public void init() {
        this._conditions = this._conditionsList.toArray(new Condition[this._conditionsList.size()]);
        this._conditionsList = null;
    }

    protected Condition[] getConditions() {
        return this._conditions;
    }
}

