/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.VersionFactory;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.Config;
import com.caucho.util.CurrentTime;
import com.caucho.vfs.Path;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResinVar {
    private static final Logger log = Logger.getLogger(ResinVar.class.getName());
    private String _serverId;
    private Path _resinHome;
    private Path _resinRoot;
    private Path _resinLog;
    private Path _resinConf;
    private boolean _isProfessional;
    private CloudServer _selfServer;

    ResinVar(String serverId, Path resinHome, Path resinRoot, Path resinLog, Path resinConf, boolean isProfessional, CloudServer selfServer) {
        this._serverId = serverId;
        this._resinHome = resinHome;
        this._resinRoot = resinRoot;
        this._resinLog = resinLog;
        this._resinConf = resinConf;
        this._isProfessional = isProfessional;
        this._selfServer = selfServer;
    }

    public String getServerId() {
        String serverId = (String)Config.getProperty((String)"rvar0");
        if (serverId != null) {
            return serverId;
        }
        return this._serverId;
    }

    public String getId() {
        return this.getServerId();
    }

    public String getAddress() {
        try {
            if (this._selfServer != null) {
                return this._selfServer.getAddress();
            }
            if (CurrentTime.isTest()) {
                return "127.0.0.1";
            }
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return "localhost";
        }
    }

    public Path getConf() {
        return this._resinConf;
    }

    public Path getHome() {
        return this._resinHome;
    }

    public Path getRoot() {
        return this._resinRoot;
    }

    public Path getRootDir() {
        return this.getRoot();
    }

    public Path getRootDirectory() {
        return this.getRoot();
    }

    public Path getLogDirectory() {
        return this._resinLog;
    }

    public String getUserName() {
        return System.getProperty("user.name");
    }

    public int getPort() {
        if (this._selfServer != null) {
            return this._selfServer.getPort();
        }
        return 0;
    }

    public String getHttpAddress() {
        return this.getAddress();
    }

    public String getHttpsAddress() {
        return this.getAddress();
    }

    public int getHttpPort() {
        return 0;
    }

    public int getHttpsPort() {
        return 0;
    }

    public String getVersion() {
        if (CurrentTime.isTest()) {
            return "3.1.test";
        }
        return VersionFactory.getVersion();
    }

    public String getVersionDate() {
        if (CurrentTime.isTest()) {
            return "19980508T0251";
        }
        return VersionFactory.getVersionDate();
    }

    public String getHostName() {
        try {
            if (CurrentTime.isTest()) {
                return "localhost";
            }
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            Logger.getLogger(ResinVar.class.getName()).log(Level.FINE, e.toString(), e);
            return "localhost";
        }
    }

    public boolean isProfessional() {
        return this._isProfessional;
    }
}

