/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.resin;

import com.caucho.cloud.network.ClusterServerProgram;
import com.caucho.cloud.topology.CloudServer;
import com.caucho.config.Configurable;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.server.resin.BootPodConfig;

public class BootServerConfig
implements SchemaBean {
    private final BootPodConfig _pod;
    private String _id = "default";
    private String _address = "127.0.0.1";
    private int _port = -1;
    private boolean _isSecure;
    private boolean _isRequireExplicitId;
    private boolean _isExternalAddress;
    private boolean _isAllowExternalAddress;
    private ContainerProgram _serverProgram = new ContainerProgram();

    public BootServerConfig(BootPodConfig pod) {
        this._pod = pod;
    }

    public BootPodConfig getPod() {
        return this._pod;
    }

    public String getSchema() {
        return "com/caucho/server/resin/server.rnc";
    }

    public String getId() {
        return this._id;
    }

    @Configurable
    public void setId(String id) {
        if (id == null || id.equals("")) {
            id = "default";
        }
        this._id = id;
    }

    public String getAddress() {
        return this._address;
    }

    @Configurable
    public void setAddress(String address) {
        this._address = address;
    }

    public int getPort() {
        return this._port;
    }

    @Configurable
    public void setPort(int port) {
        this._port = port;
    }

    public boolean isSecure() {
        return this._isSecure;
    }

    @Configurable
    public void setRequireExplicitId(boolean isRequire) {
        this._isRequireExplicitId = isRequire;
    }

    @Configurable
    public boolean isRequireExplicitId() {
        return this._isRequireExplicitId;
    }

    @Configurable
    public void setExternalAddress(boolean isExternal) {
        this._isExternalAddress = isExternal;
    }

    @Configurable
    public boolean isAllowExternalAddress() {
        return this._isAllowExternalAddress;
    }

    @Configurable
    public void setAllowNonReservedIp(boolean isExternal) {
        this._isAllowExternalAddress = isExternal;
    }

    @Configurable
    public boolean isExternalAddress() {
        return this._isExternalAddress;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public ConfigProgram getServerProgram() {
        return this._serverProgram;
    }

    public void initTopology() {
        BootPodConfig pod = this.getPod();
        pod.initTopology(this);
    }

    void initTopology(CloudServer cloudServer) {
        cloudServer.putData(new ClusterServerProgram((ConfigProgram)this._serverProgram));
    }

    public String getFullAddress() {
        return (this.isExternalAddress() ? "ext:" : "") + this.getAddress() + (this.getPort() > 0 ? ":" + this.getPort() : "");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

