/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.server.http.AbstractCauchoRequest;
import com.caucho.server.util.CauchoSystem;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.CharBuffer;
import com.caucho.util.HashMapImpl;
import com.caucho.util.L10N;
import com.caucho.vfs.MultipartStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.Part;

class MultipartFormParser {
    private static final Logger log = Logger.getLogger(MultipartFormParser.class.getName());
    static final L10N L = new L10N(MultipartFormParser.class);

    MultipartFormParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parsePostData(HashMapImpl<String, String[]> table, List<Part> parts, ReadStream rawIs, String boundary, AbstractCauchoRequest request, String javaEncoding, long uploadMax, long fileUploadMax, long lengthMax) throws IOException {
        ReadStream is;
        MultipartStream ms = new MultipartStream(rawIs, boundary);
        ms.setEncoding(javaEncoding);
        while ((is = ms.openRead()) != null) {
            String attr = ms.getAttribute("content-disposition");
            if (attr == null || !attr.startsWith("form-data")) continue;
            String name = MultipartFormParser.getAttribute(attr, "name");
            String filename = MultipartFormParser.getAttribute(attr, "filename");
            String contentType = MultipartFormParser.getAttribute(attr, "content-type");
            String value = null;
            Path tempFile = null;
            if (contentType == null) {
                contentType = ms.getAttribute("content-type");
            }
            if (name == null) continue;
            if (filename != null) {
                Path tempDir = CauchoSystem.getWorkPath().lookup("form");
                try {
                    tempDir.mkdirs();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                tempFile = tempDir.createTempFile("form", ".tmp");
                request.addCloseOnExit(tempFile);
                WriteStream os = tempFile.openWrite();
                TempBuffer tempBuffer = TempBuffer.allocate();
                byte[] buf = tempBuffer.getBuffer();
                int totalLength = 0;
                try {
                    int len;
                    while ((len = is.read(buf, 0, buf.length)) > 0) {
                        os.write(buf, 0, len);
                        totalLength += len;
                    }
                }
                finally {
                    os.close();
                    TempBuffer.free((TempBuffer)tempBuffer);
                    tempBuffer = null;
                }
                if (uploadMax > 0L && uploadMax < tempFile.getLength()) {
                    String msg = L.l("multipart form data '{0}' too large", (Object)("" + tempFile.getLength()));
                    long fileLength = tempFile.getLength();
                    tempFile.remove();
                    throw MultipartFormParser.formError(msg, fileLength, request);
                }
                if (fileUploadMax > 0L && fileUploadMax < tempFile.getLength()) {
                    String msg = L.l("multipart form data part '{0}':'{1}' is greater then the accepted value of '{2}'", (Object)name, (Object)("" + tempFile.getLength()), (Object)fileUploadMax);
                    tempFile.remove();
                    throw new IllegalStateException(msg);
                }
                if (tempFile.getLength() != (long)totalLength) {
                    String msg = L.l("multipart form upload failed (possibly due to full disk).");
                    long fileLength = tempFile.getLength();
                    tempFile.remove();
                    throw MultipartFormParser.formError(msg, fileLength, request);
                }
                WebApp webapp = request.getWebApp();
                if (webapp != null && webapp.isMultipartFormEnabled()) {
                    if (table.get((Object)(name + ".filename")) == null) {
                        table.put((Object)name, (Object)new String[]{tempFile.getNativePath()});
                        table.put((Object)(name + ".file"), (Object)new String[]{tempFile.getNativePath()});
                        table.put((Object)(name + ".filename"), (Object)new String[]{filename});
                        table.put((Object)(name + ".content-type"), (Object)new String[]{contentType});
                    } else {
                        MultipartFormParser.addTable(table, name, tempFile.getNativePath());
                        MultipartFormParser.addTable(table, name + ".file", tempFile.getNativePath());
                        MultipartFormParser.addTable(table, name + ".filename", filename);
                        MultipartFormParser.addTable(table, name + ".content-type", contentType);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine("mp-file: " + name + "(filename:" + filename + ")");
                }
            } else {
                CharBuffer valueBuffer = new CharBuffer();
                long totalLength = 0L;
                int ch = is.readChar();
                while (ch >= 0) {
                    valueBuffer.append((char)ch);
                    if (lengthMax < ++totalLength) {
                        String msg = L.l("multipart form upload failed because field '{0}' exceeds max length {1}", (Object)name, (Object)lengthMax);
                        throw MultipartFormParser.formError(msg, totalLength, request);
                    }
                    ch = is.readChar();
                }
                value = valueBuffer.toString();
                if (log.isLoggable(Level.FINE)) {
                    log.fine("mp-form: " + name + "=" + value);
                }
                MultipartFormParser.addTable(table, name, value);
                if (contentType != null) {
                    MultipartFormParser.addTable(table, name + ".content-type", contentType);
                }
            }
            parts.add(request.createPart(name, contentType, new HashMap<String, List<String>>(ms.getHeaders()), tempFile, value));
        }
        if (!ms.isComplete()) {
            throw MultipartFormParser.formError(L.l("End of post before multipart-mime boundary"), -1L, request);
        }
    }

    private static IOException formError(String msg, long length, AbstractCauchoRequest request) throws IOException {
        log.fine(request.getRequestURI() + ": " + msg);
        request.setAttribute("caucho.multipart.form.error", msg);
        request.setAttribute("caucho.multipart.form.error.size", new Long(length));
        throw new IOException(msg);
    }

    private static void addTable(HashMapImpl<String, String[]> table, String name, String value) {
        String[] oldArray = (String[])table.get((Object)name);
        if (oldArray != null) {
            String[] newArray = new String[oldArray.length + 1];
            System.arraycopy(oldArray, 0, newArray, 0, oldArray.length);
            newArray[oldArray.length] = value;
            table.put((Object)name, (Object)newArray);
        } else {
            table.put((Object)name, (Object)new String[]{value});
        }
    }

    private static String getAttribute(String attr, String name) {
        CharBuffer value;
        block8: {
            char ch;
            int i;
            int length;
            block9: {
                block7: {
                    if (attr == null) {
                        return null;
                    }
                    length = attr.length();
                    i = MultipartFormParser.findAttribute(attr, name);
                    if (i < 0) {
                        return null;
                    }
                    if (length <= i || attr.charAt(i) != '=') {
                        return null;
                    }
                    ++i;
                    while (i < length && attr.charAt(i) == ' ') {
                        ++i;
                    }
                    value = CharBuffer.allocate();
                    if (i >= length || attr.charAt(i) != '\'') break block7;
                    ++i;
                    while (i < length && attr.charAt(i) != '\'') {
                        value.append(attr.charAt(i));
                        ++i;
                    }
                    break block8;
                }
                if (i >= length || attr.charAt(i) != '\"') break block9;
                ++i;
                while (i < length && attr.charAt(i) != '\"') {
                    value.append(attr.charAt(i));
                    ++i;
                }
                break block8;
            }
            if (i >= length) break block8;
            while (i < length && (ch = attr.charAt(i)) != ' ' && ch != ';') {
                value.append(ch);
                ++i;
            }
        }
        return value.close();
    }

    private static int findAttribute(String attribute, String name) {
        int length = attribute.length();
        int nameLength = name.length();
        block0: for (int i = 0; i < length - nameLength; ++i) {
            char ch;
            if (!attribute.regionMatches(true, i, name, 0, nameLength) || i > 0 && (ch = attribute.charAt(i - 1)) != ' ' && ch != ';' && ch != '\t') continue;
            for (int j = i + nameLength; j < length; ++j) {
                ch = attribute.charAt(j);
                if (ch == '=') {
                    return j;
                }
                if (ch != ' ' && ch != '\t') continue block0;
            }
        }
        return -1;
    }
}

