/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.http;

import com.caucho.util.CharSegment;

public final class HttpBufferStore {
    private final byte[] _uri;
    private final char[] _headerBuffer;
    private final int _headerCapacity;
    private final CharSegment[] _headerKeys;
    private final CharSegment[] _headerValues;

    public HttpBufferStore(int urlLengthMax, int headerSizeMax, int headerCountMax) {
        this._uri = new byte[urlLengthMax];
        this._headerBuffer = new char[headerSizeMax];
        this._headerCapacity = headerCountMax;
        this._headerKeys = new CharSegment[this._headerCapacity];
        this._headerValues = new CharSegment[this._headerCapacity];
        for (int i = 0; i < this._headerCapacity; ++i) {
            this._headerKeys[i] = new CharSegment();
            this._headerValues[i] = new CharSegment();
        }
    }

    public final byte[] getUriBuffer() {
        return this._uri;
    }

    public final char[] getHeaderBuffer() {
        return this._headerBuffer;
    }

    public final int getHeaderCapacity() {
        return this._headerCapacity;
    }

    public final CharSegment[] getHeaderKeys() {
        return this._headerKeys;
    }

    public final CharSegment[] getHeaderValues() {
        return this._headerValues;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

