/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.hmux;

import com.caucho.loader.EnvironmentLocal;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.http.AbstractHttpProtocol;
import java.util.HashMap;

public class HmuxProtocol
extends AbstractHttpProtocol {
    private static EnvironmentLocal<HmuxProtocol> _localManager = new EnvironmentLocal();
    private HashMap<Integer, Protocol> _extensionMap = new HashMap();

    public HmuxProtocol() {
        this.setProtocolName("server");
        _localManager.set((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HmuxProtocol getLocal() {
        EnvironmentLocal<HmuxProtocol> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            return (HmuxProtocol)_localManager.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HmuxProtocol create() {
        EnvironmentLocal<HmuxProtocol> environmentLocal = _localManager;
        synchronized (environmentLocal) {
            HmuxProtocol protocol = (HmuxProtocol)_localManager.get();
            if (protocol == null) {
                protocol = new HmuxProtocol();
                _localManager.set((Object)protocol);
            }
            return protocol;
        }
    }

    @Override
    public ProtocolConnection createConnection(SocketLink conn) {
        return new HmuxRequest(this.getServletSystem(), conn, this);
    }

    public Protocol getExtension(Integer id) {
        return this._extensionMap.get(id);
    }

    public void putExtension(int id, Protocol protocol) {
        this._extensionMap.put(id, protocol);
    }
}

