/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.embed;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.resin.HttpEmbed;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ResinArgs;
import com.caucho.server.resin.ResinEmbedded;
import com.caucho.server.webapp.WebAppConfig;
import java.io.IOException;
import java.io.InputStream;

public class ResinEmbed {
    private static final String EMBED_CONF = "com/caucho/server/embed/resin-embed.xml";
    private Resin _resin;
    private Host _host;
    private ServletService _server;
    private int _httpPort = -1;
    private Lifecycle _lifecycle = new Lifecycle();

    public ResinEmbed() {
        InputStream is = null;
        try {
            ResinArgs args = new ResinArgs();
            args.setServerId("embed");
            this._resin = new ResinEmbedded(args);
            Config config = new Config();
            is = this._resin.getClassLoader().getResourceAsStream(EMBED_CONF);
            config.configure((Object)this._resin, is);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void setHttpPort(int port) {
        this._httpPort = port;
    }

    public void addWebApp(String contextPath, String rootDirectory) {
        try {
            this.start();
            WebAppConfig config = new WebAppConfig();
            config.setContextPath(contextPath);
            config.setRootDirectory(new RawString(rootDirectory));
            this._host.getWebAppContainer().addWebApp(config);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        try {
            this._resin.start();
            this._server = this._resin.getServer();
            if (this._httpPort >= 0) {
                HttpEmbed httpEmbed = new HttpEmbed(this._httpPort);
                httpEmbed.bindTo(this._server);
            }
            HostConfig hostConfig = new HostConfig();
            this._server.addHost(hostConfig);
            this._host = this._server.getHost("", 0);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        try {
            this._resin.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        try {
            this._resin.destroy();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this._resin.destroy();
    }
}

