/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.server.distcache.CacheConfig;
import java.io.Serializable;

public class MnodeValue
implements Serializable {
    private final long _valueHash;
    private final long _valueLength;
    private final long _version;
    private final long _flags;
    private final long _accessedExpireTimeout;
    private final long _modifiedExpireTimeout;
    private final long _leaseExpireTimeout;

    public MnodeValue(long valueHash, long valueLength, long version, long flags, long accessedExpireTimeout, long modifiedExpireTimeout, long leaseTimeout) {
        this._valueHash = valueHash;
        this._valueLength = valueLength;
        this._flags = flags;
        this._accessedExpireTimeout = accessedExpireTimeout;
        this._modifiedExpireTimeout = modifiedExpireTimeout;
        this._leaseExpireTimeout = leaseTimeout;
        this._version = version;
    }

    public MnodeValue(long valueHash, long valueLength, long version) {
        this(valueHash, valueLength, version, 0L, 0L, 0L, 0L);
    }

    public MnodeValue(MnodeValue mnodeValue) {
        this(mnodeValue._valueHash, mnodeValue._valueLength, mnodeValue._version, mnodeValue._flags, mnodeValue._accessedExpireTimeout, mnodeValue._modifiedExpireTimeout, mnodeValue._leaseExpireTimeout);
    }

    public MnodeValue(long valueHash, long valueLength, long version, MnodeValue oldValue) {
        this._valueHash = valueHash;
        this._valueLength = valueLength;
        this._version = version;
        if (oldValue != null) {
            this._flags = oldValue._flags;
            this._modifiedExpireTimeout = oldValue._modifiedExpireTimeout;
            this._accessedExpireTimeout = oldValue._accessedExpireTimeout;
            this._leaseExpireTimeout = oldValue._leaseExpireTimeout;
        } else {
            this._flags = 0L;
            this._modifiedExpireTimeout = -1L;
            this._accessedExpireTimeout = -1L;
            this._leaseExpireTimeout = -1L;
        }
    }

    public MnodeValue(long valueHash, long valueLength, long version, CacheConfig config) {
        this(valueHash, valueLength, version, config.getFlags(), config.getAccessedExpireTimeout(), config.getModifiedExpireTimeout(), config.getLeaseExpireTimeout());
    }

    public final long getValueHash() {
        return this._valueHash;
    }

    public final long getValueLength() {
        return this._valueLength;
    }

    public final long getVersion() {
        return this._version;
    }

    public final long getFlags() {
        return this._flags;
    }

    public final int getUserFlags() {
        return (int)(this.getFlags() >> 32);
    }

    public final long getModifiedExpireTimeout() {
        return this._modifiedExpireTimeout;
    }

    public final long getAccessedExpireTimeout() {
        return this._accessedExpireTimeout;
    }

    public final long getLeaseExpireTimeout() {
        return this._leaseExpireTimeout;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[,valueHash=" + Long.toHexString(this.getValueHash()) + ",flags=" + Long.toHexString(this.getFlags()) + ",version=" + this.getVersion() + "]";
    }
}

