/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.distcache.CacheSerializer;
import com.caucho.env.distcache.CacheDataBacking;
import com.caucho.env.service.ResinSystem;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheStoreManager;
import com.caucho.server.distcache.DataStore;
import com.caucho.server.distcache.DataStreamSource;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeValue;
import com.caucho.util.HashKey;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.util.NullOutputStream;
import com.caucho.vfs.Crc64InputStream;
import com.caucho.vfs.Crc64OutputStream;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.TempOutputStream;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LocalDataManager {
    private static final L10N L = new L10N(LocalDataManager.class);
    private static final Logger log = Logger.getLogger(LocalDataManager.class.getName());
    private final String _serverId = ResinSystem.getCurrentId();
    private final CacheStoreManager _storeManager;

    LocalDataManager(CacheStoreManager storeManager) {
        this._storeManager = storeManager;
    }

    private CacheStoreManager getStoreManager() {
        return this._storeManager;
    }

    private CacheDataBacking getDataBacking() {
        return this.getStoreManager().getDataBacking();
    }

    DataItemLocal writeData(MnodeValue update, long version, StreamSource source) {
        long valueHash = update.getValueHash();
        long valueLength = update.getValueLength();
        if (valueHash == 0L && valueLength == 0L && source == null) {
            return new DataItemLocal(0L, 0L, 0L, 0L);
        }
        DataStore.DataItem valueData = null;
        if (source == null) {
            throw new IllegalStateException(L.l("writeData called without a stream or saved value {0}", (Object)update));
        }
        valueData = this.getDataBacking().saveData(source, (int)valueLength);
        return new DataItemLocal(valueHash, valueData, valueLength);
    }

    DataItemLocal writeData(MnodeValue update, long version, InputStream is) {
        try {
            long valueHash = update.getValueHash();
            long valueLength = update.getValueLength();
            DataStore.DataItem valueData = this.getDataBacking().saveData(is, (int)valueLength);
            return new DataItemLocal(valueHash, valueData, valueLength);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final DataItemLocal writeValue(MnodeEntry mnodeValue, Object value, CacheConfig config) {
        TempOutputStream os = null;
        CacheSerializer serializer = config.getValueSerializer();
        try {
            os = new TempOutputStream();
            long valueHash = this.writeDataStream((OutputStream)os, value, serializer);
            int length = os.getLength();
            StreamSource source = new StreamSource(os);
            DataStore.DataItem valueData = this.getDataBacking().saveData(source, length);
            if (valueData == null) {
                throw new IllegalStateException(L.l("Can't save the data '{0}'", valueHash));
            }
            DataItemLocal dataItemLocal = new DataItemLocal(valueHash, valueData, (long)length);
            return dataItemLocal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                os.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object readData(HashKey key, long valueHash, long valueDataId, long valueDataTime, CacheSerializer serializer, CacheConfig config) {
        if (valueHash == 0L) {
            return null;
        }
        TempOutputStream os = null;
        try {
            Object object;
            os = new TempOutputStream();
            WriteStream out = Vfs.openWrite((OutputStream)os);
            if (!this.getDataBacking().loadData(valueDataId, valueDataTime, out)) {
                log.warning(this + " cannot load data for key=" + key + " from triad (id=" + Long.toHexString(valueDataId) + " time=" + valueDataTime + ")");
                Thread.dumpStack();
                out.close();
                Object var12_10 = null;
                return var12_10;
            }
            out.close();
            InputStream is = os.openInputStream();
            try {
                Object value;
                object = value = serializer.deserialize(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    Object var12_11 = null;
                    return var12_11;
                }
            }
            is.close();
            return object;
        }
        finally {
            if (os != null) {
                os.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object decodeValue(InputStream is, CacheSerializer serializer) {
        if (is == null) {
            return null;
        }
        try {
            Object object = serializer.deserialize(is);
            return object;
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            IoUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean readData(HashKey key, MnodeEntry mnodeValue, OutputStream os, CacheConfig config) throws IOException {
        long valueDataId = mnodeValue.getValueDataId();
        long valueDataTime = mnodeValue.getValueDataTime();
        if (valueDataId <= 0L) {
            throw new IllegalStateException(L.l("readData may not be called with a null value"));
        }
        WriteStream out = Vfs.openWrite((OutputStream)os);
        try {
            Blob blob = mnodeValue.getBlob();
            if (blob == null && (blob = this.getDataBacking().loadBlob(valueDataId, valueDataTime)) != null) {
                mnodeValue.setBlob(blob);
            }
            if (blob != null) {
                this.loadData(blob, out);
                boolean bl = true;
                return bl;
            }
            log.warning(this + " unexpected load failure in readValue key=" + key);
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != os) {
                out.close();
            }
        }
    }

    public DataStreamSource createDataSource(long valueDataId, long valueDataTime) {
        DataStore dataStore = this.getDataBacking().getDataStore();
        if (valueDataId > 0L) {
            return new DataStreamSource(valueDataId, valueDataTime, dataStore);
        }
        return null;
    }

    private void loadData(Blob blob, WriteStream out) throws IOException {
        try {
            InputStream is = blob.getBinaryStream();
            if (is instanceof BlobInputStream) {
                BlobInputStream blobIs = (BlobInputStream)is;
                blobIs.readToOutput((OutputStream)out);
            } else {
                out.writeStream(blob.getBinaryStream());
            }
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    void removeData(long valueHash, long valueDataTime) {
        this.getDataBacking().removeData(valueHash, valueDataTime);
    }

    public final long calculateValueHash(Object value, CacheConfig config) {
        try {
            NullOutputStream os = NullOutputStream.NULL;
            return this.writeDataStream((OutputStream)os, value, config.getValueSerializer());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long writeDataStream(OutputStream os, Object value, CacheSerializer serializer) throws IOException {
        Crc64OutputStream mOut = new Crc64OutputStream(os);
        serializer.serialize(value, (OutputStream)mOut);
        mOut.close();
        long hash = mOut.getDigest();
        if (hash == 0L || hash == MnodeEntry.ANY_KEY) {
            return 1L;
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DataItemLocal writeData(StreamSource source) {
        if (source == null) {
            return new DataItemLocal(0L, 0L, 0L, 0L);
        }
        InputStream is = null;
        try {
            is = source.getInputStream();
            DataItemLocal dataItemLocal = this.writeData(is);
            return dataItemLocal;
        }
        catch (IOException e) {
            log.log(Level.FINE, e.toString(), e);
            DataItemLocal dataItemLocal = new DataItemLocal(0L, 0L, 0L, 0L);
            return dataItemLocal;
        }
        finally {
            IoUtil.close((InputStream)is);
        }
    }

    public final DataItemLocal writeData(InputStream is) throws IOException {
        Object os = null;
        try {
            Crc64InputStream mIn = new Crc64InputStream(is);
            DataStore.DataItem valueData = this.getDataBacking().saveData((InputStream)mIn, -1);
            long valueHash = mIn.getDigest();
            if (valueHash == 0L || valueHash == MnodeEntry.ANY_KEY) {
                valueHash = 1L;
            }
            long length = mIn.getLength();
            DataItemLocal dataItemLocal = new DataItemLocal(valueHash, valueData, length);
            return dataItemLocal;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (os != null) {
                os.destroy();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serverId + "]";
    }

    public static class DataItemLocal {
        private long _valueHash;
        private long _dataId;
        private long _dataTime;
        private long _length;

        private DataItemLocal(long valueHash, long dataId, long dataTime, long length) {
            this._valueHash = valueHash;
            this._dataId = dataId;
            this._dataTime = dataTime;
            this._length = length;
        }

        private DataItemLocal(long valueHash, DataStore.DataItem data, long length) {
            this._valueHash = valueHash;
            if (data != null) {
                this._dataId = data.getId();
                this._dataTime = data.getTime();
            }
            this._length = length;
        }

        public long getValueDataId() {
            return this._dataId;
        }

        public long getValueDataTime() {
            return this._dataTime;
        }

        public long getValueHash() {
            return this._valueHash;
        }

        public long getLength() {
            return this._length;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[id=" + this._dataId + ",hash=" + this._valueHash + ",length=" + this._length + "]";
        }
    }
}

