/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.ExtCacheEntry;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.server.distcache.MnodeEntry;
import com.caucho.server.distcache.MnodeUpdate;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import com.caucho.vfs.StreamSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

public final class ExtCacheEntryFacade
implements ExtCacheEntry {
    private static final Logger log = Logger.getLogger(ExtCacheEntryFacade.class.getName());
    private final DistCacheEntry _entry;
    private final MnodeEntry _mnodeEntry;

    ExtCacheEntryFacade(DistCacheEntry entry) {
        this._entry = entry;
        this._mnodeEntry = entry.getMnodeEntry();
    }

    public final Object getKey() {
        return this._entry.getKey();
    }

    @Override
    public final HashKey getKeyHash() {
        return this._entry.getKeyHash();
    }

    public Object getValue() {
        return this._mnodeEntry.getValue();
    }

    @Override
    public boolean isValueNull() {
        return this._mnodeEntry.isValueNull();
    }

    @Override
    public final int getUserFlags() {
        return this._mnodeEntry.getUserFlags();
    }

    @Override
    public StreamSource getValueStream() {
        return this._entry.getValueStream();
    }

    @Override
    public long getValueHash() {
        return this._mnodeEntry.getValueHash();
    }

    @Override
    public long getValueLength() {
        return this._mnodeEntry.getValueLength();
    }

    @Override
    public boolean readData(OutputStream os, CacheConfig config) throws IOException {
        return this._entry.readData(os, config);
    }

    @Override
    public long getAccessedExpireTimeout() {
        return this._mnodeEntry.getAccessedExpireTimeout();
    }

    @Override
    public long getModifiedExpireTimeout() {
        return this._mnodeEntry.getModifiedExpireTimeout();
    }

    @Override
    public boolean isExpired(long now) {
        return this._mnodeEntry.isExpired(now);
    }

    @Override
    public void updateAccessTime() {
        this._entry.updateAccessTime();
    }

    @Override
    public long getLeaseExpireTimeout() {
        return this._mnodeEntry.getLeaseExpireTimeout();
    }

    @Override
    public int getLeaseOwner() {
        if (!this._mnodeEntry.isLeaseExpired(CurrentTime.getCurrentTime())) {
            return this._mnodeEntry.getLeaseOwner();
        }
        return -1;
    }

    @Override
    public long getLastAccessedTime() {
        return this._mnodeEntry.getLastAccessedTime();
    }

    @Override
    public long getLastModifiedTime() {
        return this._mnodeEntry.getLastModifiedTime();
    }

    @Override
    public long getVersion() {
        return this._mnodeEntry.getVersion();
    }

    @Override
    public MnodeUpdate getRemoteUpdate() {
        return this._mnodeEntry.getRemoteUpdate();
    }

    @Override
    public boolean isValid() {
        return this._mnodeEntry.isValid();
    }

    @Override
    public int getLoadCount() {
        return this._entry.getLoadCount();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._mnodeEntry + "]";
    }
}

