/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.distcache.CacheSerializer;
import com.caucho.inject.Module;
import com.caucho.server.distcache.CacheConfig;
import com.caucho.server.distcache.CacheEntryManager;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.DistCacheEntry;
import com.caucho.util.FreeList;
import com.caucho.util.HashKey;
import com.caucho.util.LruCache;
import java.io.OutputStream;
import java.security.MessageDigest;

@Module
public final class CacheKeyManager {
    private static final Object NULL_OBJECT = new Object();
    private final CacheEntryManager _cacheEntryManager;
    private FreeList<KeyHashStream> _keyStreamFreeList = new FreeList(32);
    private final LruCache<CacheKey, HashKey> _keyCache;

    CacheKeyManager(CacheEntryManager cacheEntryManager) {
        this._cacheEntryManager = cacheEntryManager;
        this._keyCache = new LruCache(65536);
    }

    public final CacheEntryManager getCacheEntryManager() {
        return this._cacheEntryManager;
    }

    public final DistCacheEntry getCacheEntry(Object key, CacheHandle cache) {
        HashKey hashKey = this.createHashKey(key, cache.getConfig());
        DistCacheEntry entry = this._cacheEntryManager.createCacheEntry(hashKey, cache);
        if (key != null) {
            entry.setKey(key);
        }
        return entry;
    }

    public final DistCacheEntry getCacheEntry(HashKey hashKey, CacheHandle cache) {
        return this._cacheEntryManager.createCacheEntry(hashKey, cache);
    }

    final DistCacheEntry getLocalEntry(HashKey key, CacheHandle cache) {
        if (key == null) {
            throw new NullPointerException();
        }
        DistCacheEntry entry = this.getCacheEntry(key, cache);
        return entry;
    }

    public void closeCache(String guid) {
        this._keyCache.clear();
    }

    protected HashKey createHashKey(Object key, CacheConfig config) {
        CacheKey cacheKey = new CacheKey(config.getGuid(), config.getGuidHash(), key);
        HashKey hashKey = (HashKey)this._keyCache.get((Object)cacheKey);
        if (hashKey == null) {
            hashKey = this.createHashKeyImpl(key, config);
            this._keyCache.put((Object)cacheKey, (Object)hashKey);
        }
        return hashKey;
    }

    protected HashKey createHashKeyImpl(Object key, CacheConfig config) {
        try {
            KeyHashStream dOut = (KeyHashStream)this._keyStreamFreeList.allocate();
            if (dOut == null) {
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                dOut = new KeyHashStream(digest);
            }
            dOut.init();
            CacheSerializer keySerializer = config.getKeySerializer();
            keySerializer.serialize(config.getGuid(), dOut);
            keySerializer.serialize(key, dOut);
            HashKey hashKey = new HashKey(dOut.digest());
            this._keyStreamFreeList.free((Object)dOut);
            return hashKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HashKey createSelfHashKey(Object key, CacheSerializer keySerializer) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            KeyHashStream dOut = new KeyHashStream(digest);
            keySerializer.serialize(key, dOut);
            HashKey hashKey = new HashKey(dOut.digest());
            return hashKey;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cacheEntryManager + "]";
    }

    static class KeyHashStream
    extends OutputStream {
        private MessageDigest _digest;

        KeyHashStream(MessageDigest digest) {
            this._digest = digest;
        }

        void init() {
            this._digest.reset();
        }

        @Override
        public void write(int value) {
            this._digest.update((byte)value);
        }

        @Override
        public void write(byte[] buffer, int offset, int length) {
            this._digest.update(buffer, offset, length);
        }

        public byte[] digest() {
            byte[] digest = this._digest.digest();
            return digest;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    static final class CacheKey {
        private final String _guid;
        private final Object _key;
        private final int _hashCode;

        CacheKey(String guid, int guidHash, Object key) {
            this._guid = guid;
            if (key == null) {
                key = NULL_OBJECT;
            }
            this._key = key;
            this._hashCode = 65521 * (17 + guidHash) + key.hashCode();
        }

        public final int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            CacheKey key = (CacheKey)o;
            if (!key._key.equals(this._key)) {
                return false;
            }
            return key._guid.equals(this._guid);
        }
    }
}

