/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.distcache;

import com.caucho.config.Configurable;
import com.caucho.distcache.CacheSerializer;
import com.caucho.distcache.HessianSerializer;
import com.caucho.distcache.ResinCacheBuilder;
import com.caucho.server.distcache.AbstractCacheEngine;
import com.caucho.server.distcache.CacheEngine;
import com.caucho.server.distcache.CacheHandle;
import com.caucho.server.distcache.CacheLoaderAdapter;
import com.caucho.server.distcache.CacheLoaderExt;
import com.caucho.server.distcache.CacheWriterAdapter;
import com.caucho.server.distcache.CacheWriterExt;
import com.caucho.util.CurrentTime;
import com.caucho.util.HashKey;
import java.util.concurrent.TimeUnit;
import javax.cache.CacheLoader;
import javax.cache.CacheWriter;
import javax.cache.Configuration;
import javax.cache.ExpiryPolicy;
import javax.cache.transaction.IsolationLevel;
import javax.cache.transaction.Mode;

public class CacheConfig
implements Configuration {
    public static final long TIME_INFINITY = 0x3FFFFFFFFFFFFFFFL;
    public static final long TIME_HOUR = 3600000L;
    public static final int FLAG_TRANSIENT = 1;
    public static final int FLAG_BACKUP = 2;
    public static final int FLAG_TRIPLICATE = 4;
    public static final int FLAG_CLUSTER = 8;
    public static final int FLAG_GLOBAL = 16;
    private String _guid;
    private int _guidHash;
    private CacheHandle _cache;
    private int _flags = 6;
    private long _modifiedExpireTimeout = 0x3FFFFFFFFFFFFFFFL;
    private long _modifiedExpireTimeoutWindow = 0L;
    private long _accessedExpireTimeout = 0x3FFFFFFFFFFFFFFFL;
    private long _accessedExpireTimeoutWindow = -1L;
    private long _localExpireTimeout = CurrentTime.isTest() ? -1L : 250L;
    private long _leaseExpireTimeout = 300000L;
    private ResinCacheBuilder.Scope _scope = ResinCacheBuilder.Scope.CLUSTER;
    private boolean _isReadThrough;
    private CacheLoaderExt _cacheLoader;
    private long _readThroughExpireTimeout = 0x3FFFFFFFFFFFFFFFL;
    private boolean _isWriteThrough;
    private CacheWriterExt _cacheWriter;
    private boolean _isStoreByValue = true;
    private boolean _isStatisticsEnabled;
    private boolean _isTransactionEnabled;
    private CacheSerializer _keySerializer;
    private CacheSerializer _valueSerializer;
    private CacheEngine _engine = new AbstractCacheEngine();
    private ExpiryPolicy _expiryPolicy;

    public CacheConfig() {
        this._expiryPolicy = new ExpiryPolicy.Default();
    }

    public CacheConfig(Configuration cfg) {
        this.setStoreByValue(cfg.isStoreByValue());
        this._expiryPolicy = cfg.getExpiryPolicy();
        this.setWriteThrough(cfg.isWriteThrough());
        this.setCacheWriter(cfg.getCacheWriter());
        this.setReadThrough(cfg.isReadThrough());
        this.setCacheLoader(cfg.getCacheLoader());
        this.setStatisticsEnabled(cfg.isStatisticsEnabled());
    }

    public CacheLoader getCacheLoader() {
        return this._cacheLoader;
    }

    public CacheLoaderExt getCacheLoaderExt() {
        return this._cacheLoader;
    }

    public void setCacheLoader(CacheLoader cacheLoader) {
        this._cacheLoader = cacheLoader == null ? null : (cacheLoader instanceof CacheLoaderExt ? (CacheLoaderExt)cacheLoader : new CacheLoaderAdapter(cacheLoader));
    }

    public boolean isReadThrough() {
        return this._isReadThrough;
    }

    public void setReadThrough(boolean isReadThrough) {
        this._isReadThrough = isReadThrough;
    }

    public long getReadThroughExpireTimeout() {
        return this._readThroughExpireTimeout;
    }

    public void setReadThroughExpireTimeout(long timeout) {
        this._readThroughExpireTimeout = timeout;
    }

    public CacheWriter getCacheWriter() {
        return this._cacheWriter;
    }

    public void setCacheWriter(CacheWriter cacheWriter) {
        this._cacheWriter = cacheWriter == null ? null : (cacheWriter instanceof CacheWriterExt ? (CacheWriterExt)cacheWriter : new CacheWriterAdapter(cacheWriter));
    }

    public CacheWriterExt getCacheWriterExt() {
        return this._cacheWriter;
    }

    public boolean isWriteThrough() {
        return this._isWriteThrough;
    }

    public void setWriteThrough(boolean isWriteThrough) {
        this._isWriteThrough = isWriteThrough;
    }

    public String getGuid() {
        return this._guid;
    }

    public void setGuid(String guid) {
        this._guid = guid;
        this._guidHash = guid.hashCode();
    }

    public int getGuidHash() {
        return this._guidHash;
    }

    public HashKey getCacheKey() {
        return this._cache.getCacheKey();
    }

    public void setCache(CacheHandle cache) {
        this._cache = cache;
    }

    public CacheHandle getCache() {
        return this._cache;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public long getModifiedExpireTimeout() {
        return this._modifiedExpireTimeout;
    }

    @Configurable
    public void setModifiedExpireTimeout(long expireTimeout) {
        if (expireTimeout < 0L || 0x3FFFFFFFFFFFFFFFL <= expireTimeout) {
            expireTimeout = 0x3FFFFFFFFFFFFFFFL;
        }
        this._modifiedExpireTimeout = expireTimeout;
    }

    public long getModifiedExpireTimeoutWindow() {
        return this._modifiedExpireTimeoutWindow > 0L ? this._modifiedExpireTimeoutWindow : this._modifiedExpireTimeout / 4L;
    }

    @Configurable
    public void setModifiedExpireTimeoutWindow(long expireTimeoutWindow) {
        this._modifiedExpireTimeoutWindow = expireTimeoutWindow;
    }

    public long getAccessedExpireTimeout() {
        return this._accessedExpireTimeout;
    }

    public void setAccessedExpireTimeout(long timeout) {
        if (timeout < 0L || 0x3FFFFFFFFFFFFFFFL <= timeout) {
            timeout = 0x3FFFFFFFFFFFFFFFL;
        }
        this._accessedExpireTimeout = timeout;
    }

    public long getAccessedExpireTimeoutWindow() {
        return this._accessedExpireTimeoutWindow > 0L ? this._accessedExpireTimeoutWindow : this._accessedExpireTimeout / 4L;
    }

    public void setAccessedExpireTimeoutWindow(long idleTimeoutWindow) {
        this._accessedExpireTimeoutWindow = idleTimeoutWindow;
    }

    public long getLeaseExpireTimeout() {
        return this._leaseExpireTimeout;
    }

    public void setLeaseExpireTimeout(long timeout) {
        this._leaseExpireTimeout = timeout;
    }

    public long getLocalExpireTimeout() {
        return this._localExpireTimeout;
    }

    public void setLocalExpireTimeout(long timeout) {
        this._localExpireTimeout = timeout;
    }

    public boolean isSynchronousGet() {
        return this.getLocalExpireTimeout() <= 0L;
    }

    public CacheSerializer getKeySerializer() {
        return this._keySerializer;
    }

    public CacheSerializer getValueSerializer() {
        return this._valueSerializer;
    }

    public void setValueSerializer(CacheSerializer serializer) {
        this._valueSerializer = serializer;
    }

    public boolean isBackup() {
        return (this.getFlags() & 2) != 0;
    }

    public static boolean isBackup(int flags) {
        return (flags & 2) != 0;
    }

    private void setBackup(boolean isBackup) {
        if (isBackup) {
            this.setFlags(this.getFlags() | 2);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFD);
        }
    }

    public boolean isGlobal() {
        return (this.getFlags() & 0x10) != 0;
    }

    public static boolean isGlobal(int flags) {
        return (flags & 0x10) != 0;
    }

    public void setGlobal(boolean isGlobal) {
        if (isGlobal) {
            this.setFlags(this.getFlags() | 0x10);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFEF);
        }
    }

    public boolean isTriplicate() {
        return (this.getFlags() & 4) != 0;
    }

    public static boolean isTriplicate(int flags) {
        return (flags & 4) != 0;
    }

    private void setTransient(boolean isTransient) {
        if (isTransient) {
            this.setFlags(this.getFlags() | 1);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFE);
        }
    }

    private void setTriplicate(boolean isTriplicate) {
        if (isTriplicate) {
            this.setFlags(this.getFlags() | 4);
        } else {
            this.setFlags(this.getFlags() & 0xFFFFFFFB);
        }
    }

    public void setScopeMode(ResinCacheBuilder.Scope scope) {
        this._scope = scope;
    }

    public ResinCacheBuilder.Scope getScopeMode() {
        return this._scope;
    }

    public void setEngine(CacheEngine engine) {
        if (engine == null) {
            throw new NullPointerException();
        }
        this._engine = engine;
    }

    public CacheEngine getEngine() {
        return this._engine;
    }

    public int getServerIndex() {
        return this.getEngine().getServerIndex();
    }

    public void init() {
        if (this._keySerializer == null) {
            this._keySerializer = new HessianSerializer();
        }
        if (this._valueSerializer == null) {
            this._valueSerializer = new HessianSerializer();
        }
        switch (this._scope) {
            case TRANSIENT: {
                this.setTransient(true);
                this.setTriplicate(false);
                this.setBackup(false);
                this.setEngine(new AbstractCacheEngine());
                break;
            }
            case LOCAL: {
                this.setTriplicate(false);
                this.setBackup(false);
                this.setEngine(new AbstractCacheEngine());
                break;
            }
            case CLUSTER: {
                this.setTriplicate(true);
                this.setBackup(true);
            }
        }
    }

    public void setExpiry(Configuration.ExpiryType type, Configuration.Duration duration) {
        TimeUnit unit = duration.getTimeUnit();
        long timeout = unit.toMillis(duration.getDurationAmount());
        switch (type) {
            case ACCESSED: {
                this.setAccessedExpireTimeout(timeout);
                break;
            }
            case MODIFIED: {
                this.setModifiedExpireTimeout(timeout);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.valueOf(type));
            }
        }
    }

    public boolean isStatisticsEnabled() {
        return this._isStatisticsEnabled;
    }

    public void setStatisticsEnabled(boolean isEnabled) {
        this._isStatisticsEnabled = isEnabled;
    }

    public boolean isStoreByValue() {
        return this._isStoreByValue;
    }

    public void setStoreByValue(boolean isStoreByValue) {
        this._isStoreByValue = isStoreByValue;
    }

    public boolean isTransactionsEnabled() {
        return this._isTransactionEnabled;
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return IsolationLevel.NONE;
    }

    public Mode getTransactionMode() {
        return Mode.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    public Iterable getCacheEntryListenerRegistrations() {
        return null;
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }
}

