/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigELContext;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.RawString;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletMapper;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.HashMap;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.servlet.ServletException;

public class ServletRegexp {
    private static final L10N L = new L10N(ServletRegexp.class);
    private String _urlRegexp;
    private String _servletName;
    private String _servletClassName;
    private ContainerProgram _program = new ContainerProgram();

    public void setURLRegexp(String pattern) {
        this._urlRegexp = pattern;
    }

    public String getURLRegexp() {
        return this._urlRegexp;
    }

    public void setServletName(RawString string) {
        this._servletName = string.getValue();
    }

    public String getServletName() {
        return this._servletName;
    }

    public void setServletClass(RawString string) {
        this._servletClassName = string.getValue();
    }

    public String getServletClass() {
        return this._servletClassName;
    }

    public void addBuilderProgram(ConfigProgram program) {
        this._program.addProgram(program);
    }

    public ContainerProgram getBuilderProgram() {
        return this._program;
    }

    public String initRegexp(WebApp webApp, ServletMapper mapper, ArrayList<String> vars) throws ServletException {
        ELContext env = EL.getEnvironment();
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        map.put("regexp", vars);
        ConfigELContext mapEnv = new ConfigELContext((ELResolver)new MapVariableResolver(map));
        String rawName = this._servletName;
        String rawClassName = this._servletClassName;
        if (rawName == null) {
            rawName = rawClassName;
        }
        try {
            String servletName = EL.evalString((String)rawName, (ELContext)mapEnv);
            String className = EL.evalString((String)rawClassName, (ELContext)mapEnv);
            ServletConfigImpl config = new ServletConfigImpl();
            ServletMapping mapping = new ServletMapping();
            mapping.addURLRegexp(this.getURLRegexp());
            mapping.setServletName(this.getServletName());
            mapping.setServletClass(rawClassName);
            mapping.setServletContext(webApp);
            this.getBuilderProgram().configure((Object)mapping);
            mapping.setStrictMapping(webApp.getStrictMapping());
            mapping.init(mapper);
            return servletName;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._urlRegexp + "]";
    }
}

