/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.config.ConfigException;
import com.caucho.jsp.JspServlet;
import com.caucho.server.dispatch.ServletConfigException;
import com.caucho.server.dispatch.ServletConfigImpl;
import com.caucho.server.dispatch.ServletInvocation;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletSecurityElement;

public class ServletManager {
    static final Logger log = Logger.getLogger(ServletManager.class.getName());
    static final L10N L = new L10N(ServletManager.class);
    private HashMap<String, ServletConfigImpl> _servlets = new HashMap();
    private ArrayList<ServletConfigImpl> _servletList = new ArrayList();
    private ArrayList<ServletConfigImpl> _cronList = new ArrayList();
    private Map<Class<? extends Servlet>, ServletSecurityElement> _servletSecurityElements = new HashMap<Class<? extends Servlet>, ServletSecurityElement>();
    private boolean _isLazyValidate;

    public void setLazyValidate(boolean isLazy) {
        this._isLazyValidate = isLazy;
    }

    public boolean isFacesServletConfigured() {
        for (ServletConfigImpl servletConfig : this._servletList) {
            String className;
            Class servletClass = servletConfig.getServletClass();
            if (servletClass == null || !"javax.faces.webapp.FacesServlet".equals(className = servletClass.getName())) continue;
            return true;
        }
        return false;
    }

    public void addServlet(ServletConfigImpl config) throws ServletException {
        this.addServlet(config, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServlet(ServletConfigImpl config, boolean merge) throws ServletException {
        if (config.getServletContext() == null) {
            throw new NullPointerException();
        }
        config.setServletManager(this);
        HashMap<String, ServletConfigImpl> hashMap = this._servlets;
        synchronized (hashMap) {
            ServletConfigImpl mergedConfig = null;
            ServletConfigImpl existingConfig = this._servlets.get(config.getServletName());
            if (!merge && existingConfig != null) {
                for (int i = this._servletList.size() - 1; i >= 0; --i) {
                    ServletConfigImpl oldConfig = this._servletList.get(i);
                    if (!config.getServletName().equals(oldConfig.getServletName())) continue;
                    this._servletList.remove(i);
                    break;
                }
            } else if (merge && existingConfig != null) {
                mergedConfig = existingConfig;
                mergedConfig.merge(config);
            }
            try {
                if (mergedConfig == null) {
                    config.validateClass(false);
                }
            }
            catch (ConfigException e) {
                throw e;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, e.toString(), e);
                }
                if (e instanceof ConfigException) {
                    log.config(e.getMessage());
                }
                log.config(e.toString());
            }
            if (mergedConfig == null) {
                this._servlets.put(config.getServletName(), config);
                this._servletList.add(config);
            }
        }
    }

    public void addSecurityElement(Class<? extends Servlet> servletClass, ServletSecurityElement securityElement) {
        this._servletSecurityElements.put(servletClass, securityElement);
    }

    public ServletSecurityElement getSecurityElement(Class<? extends Servlet> servletClass) {
        return this._servletSecurityElements.get(servletClass);
    }

    public ServletConfigImpl getServlet(String servletName) {
        return this._servlets.get(servletName);
    }

    public HashMap<String, ServletConfigImpl> getServlets() {
        return this._servlets;
    }

    public void initializeJspServlets() throws ServletException {
        Collection<ServletConfigImpl> servlets = this._servlets.values();
        for (ServletConfigImpl servlet : servlets) {
            Class servletClass = null;
            try {
                servletClass = servlet.getServletClass();
            }
            catch (Throwable e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            if (servletClass == null || !JspServlet.class.isAssignableFrom(servletClass)) continue;
            servlet.createServlet();
        }
    }

    @PostConstruct
    public void init() throws ServletException {
        ServletConfigImpl config;
        ArrayList<ServletConfigImpl> loadOnStartup = new ArrayList<ServletConfigImpl>();
        for (int j = 0; j < this._servletList.size(); ++j) {
            int i;
            config = this._servletList.get(j);
            if (config.getLoadOnStartup() < 0) continue;
            for (i = 0; i < loadOnStartup.size(); ++i) {
                ServletConfigImpl config2 = (ServletConfigImpl)loadOnStartup.get(i);
                if (config.getLoadOnStartup() >= config2.getLoadOnStartup()) continue;
                loadOnStartup.add(i, config);
                break;
            }
            if (i == loadOnStartup.size()) {
                loadOnStartup.add(config);
            }
            if (config.getRunAt() == null && config.getCron() == null) continue;
            this._cronList.add(config);
        }
        for (int i = 0; i < loadOnStartup.size(); ++i) {
            config = (ServletConfigImpl)loadOnStartup.get(i);
            try {
                config.createServlet();
                continue;
            }
            catch (ServletException e) {
                if (config.getJspFile() == null) {
                    throw e;
                }
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public FilterChain createServletChain(String servletName, ServletConfigImpl config, ServletInvocation invocation) throws ServletException {
        if (config == null) {
            config = this._servlets.get(servletName);
        }
        if (config == null) {
            throw new ServletConfigException(L.l("'{0}' is not a known servlet.  Servlets must be defined by <servlet> before being used.", (Object)servletName));
        }
        if (invocation != null) {
            if (!config.isAsyncSupported()) {
                invocation.clearAsyncSupported();
            }
            invocation.setMultipartConfig(config.getMultipartConfig());
            if (config.getRoleMap() != null) {
                invocation.setSecurityRoleMap(config.getRoleMap());
            }
        }
        return config.createServletChain();
    }

    public Servlet createServlet(String servletName) throws ServletException {
        ServletConfigImpl config = this._servlets.get(servletName);
        if (config == null) {
            throw new ServletException(L.l("'{0}' is not a known servlet.  Servlets must be defined by <servlet> before being used.", (Object)servletName));
        }
        return (Servlet)config.createServlet();
    }

    ServletConfigImpl getServletConfig(String servletName) {
        return this._servlets.get(servletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<ServletConfigImpl> servletList = new ArrayList<ServletConfigImpl>();
        if (this._servletList != null) {
            ArrayList<ServletConfigImpl> arrayList = this._servletList;
            synchronized (arrayList) {
                servletList.addAll(this._servletList);
            }
        }
        for (int i = 0; i < servletList.size(); ++i) {
            ServletConfigImpl config = (ServletConfigImpl)servletList.get(i);
            try {
                config.close();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }
}

