/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.dispatch;

import com.caucho.server.webapp.WebApp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ForwardFilterChain
implements FilterChain {
    private static final Logger log = Logger.getLogger(ForwardFilterChain.class.getName());
    private String _url;
    private RequestDispatcher _disp;
    private boolean _isRoot;

    public ForwardFilterChain(String url) {
        this._url = url;
    }

    public ForwardFilterChain(String url, boolean isRoot) {
        this._url = url;
        this._isRoot = isRoot;
    }

    public ForwardFilterChain(RequestDispatcher disp) {
        this._disp = disp;
    }

    public void doFilter(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        try {
            if (this._disp != null) {
                this._disp.forward(request, response);
            } else {
                WebApp webApp;
                HttpServletRequest req = (HttpServletRequest)request;
                RequestDispatcher disp = this._isRoot ? ((webApp = (WebApp)req.getServletContext()) != null ? webApp.getHost().getWebAppContainer().getRequestDispatcher(this._url) : req.getRequestDispatcher(this._url)) : req.getRequestDispatcher(this._url);
                disp.forward(request, response);
            }
        }
        catch (FileNotFoundException e) {
            log.log(Level.FINER, e.toString(), e);
            HttpServletResponse res = (HttpServletResponse)response;
            res.sendError(404);
        }
    }

    public String toString() {
        if (this._disp != null) {
            return "ForwardFilterChain[" + this._disp + "]";
        }
        return "ForwardFilterChain[" + this._url + "]";
    }
}

