/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.deploy;

import com.caucho.bam.BamError;
import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.RemoteListenerUnavailableException;
import com.caucho.bam.ServiceUnavailableException;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.manager.SimpleBamManager;
import com.caucho.bam.query.QueryCallback;
import com.caucho.bam.query.QueryFutureCallback;
import com.caucho.config.ConfigException;
import com.caucho.env.git.GitCommitJar;
import com.caucho.env.git.GitCommitTree;
import com.caucho.env.git.GitObjectStream;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.env.repository.Repository;
import com.caucho.env.repository.RepositoryException;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.env.repository.RepositoryTagListener;
import com.caucho.hmtp.HmtpClient;
import com.caucho.server.admin.GitJarStreamSource;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.deploy.DeployActorProxy;
import com.caucho.server.deploy.DeployControllerState;
import com.caucho.server.deploy.DeployTagResult;
import com.caucho.server.deploy.DeployTagStateQuery;
import com.caucho.util.CurrentTime;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.InputStreamSource;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamSource;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DeployClient
implements Repository {
    private static final L10N L = new L10N(DeployClient.class);
    public static final String USER_ATTRIBUTE = "user";
    public static final String MESSAGE_ATTRIBUTE = "message";
    public static final String VERSION_ATTRIBUTE = "version";
    private static final long DEPLOY_TIMEOUT = 600000L;
    private Broker _broker;
    private ActorSender _bamClient;
    private String _deployAddress;
    private final DeployActorProxy _deployProxy;
    private String _url;
    private SimpleBamManager _bamManager;

    public DeployClient() {
        this(null);
    }

    public DeployClient(String serverId) {
        ServletService server = ServletService.getCurrent();
        if (server == null) {
            throw new IllegalStateException(L.l("DeployClient was not called in a Resin context. For external clients, use the DeployClient constructor with host,port arguments."));
        }
        this._bamClient = server.createAdminClient(this.getClass().getSimpleName());
        this._deployAddress = "deploy@resin.caucho";
        BamManager bamManager = server.getAdminBrokerManager();
        this._deployProxy = bamManager.createProxy(DeployActorProxy.class, this._deployAddress, this._bamClient);
    }

    public DeployClient(String url, ActorSender client) {
        this._bamClient = client;
        this._bamManager = new SimpleBamManager(client.getBroker());
        this._url = url;
        this._deployAddress = "deploy@resin.caucho";
        this._deployProxy = this._bamManager.createProxy(DeployActorProxy.class, this._deployAddress, this._bamClient);
    }

    public DeployClient(String host, int port, String userName, String password) {
        String url;
        this._url = url = "http://" + host + ":" + port + "/hmtp";
        HmtpClient client = new HmtpClient(url);
        try {
            client.setVirtualHost("admin.resin");
            client.connect(userName, password);
            this._bamClient = client;
            this._bamManager = new SimpleBamManager(this._bamClient.getBroker());
            this._deployAddress = "deploy@resin.caucho";
            this._deployProxy = this._bamManager.createProxy(DeployActorProxy.class, this._deployAddress, this._bamClient);
        }
        catch (RemoteConnectionFailedException e) {
            throw new RemoteConnectionFailedException(L.l("Connection to '{0}' failed for remote administration.\n  Ensure the local server has started, or include --server and --port parameters to connect to a remote server.\n  {1}", (Object)url, (Object)e.getMessage()), e);
        }
        catch (RemoteListenerUnavailableException e) {
            throw new RemoteListenerUnavailableException(L.l("Connection to '{0}' failed for remote administration because RemoteAdminService (HMTP) is not enabled.\n  Ensure <resin:RemoteAdminService> is enabled in resin.xml.\n  {1}", (Object)url, (Object)e.getMessage()), e);
        }
    }

    public String getUrl() {
        if (this._url != null) {
            return this._url;
        }
        if (this._bamClient != null) {
            return this._bamClient.getAddress();
        }
        return null;
    }

    @Override
    public String commitArchive(CommitBuilder commit, Path jar) {
        return this.commitArchive(commit, jar, 600000L);
    }

    public String commitArchive(CommitBuilder commit, Path jar, long timeout) {
        commit.validate();
        GitCommitJar gitCommit = null;
        try {
            gitCommit = new GitCommitJar(jar);
            String tag = commit.getId();
            String string = this.deployJar(tag, gitCommit, commit.getAttributes(), timeout);
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (gitCommit != null) {
                gitCommit.close();
            }
        }
    }

    @Override
    public String commitArchive(CommitBuilder commit, InputStream is) {
        commit.validate();
        GitCommitJar gitCommit = null;
        try {
            gitCommit = new GitCommitJar(is);
            String tag = commit.getId();
            long timeout = 600000L;
            String string = this.deployJar(tag, gitCommit, commit.getAttributes(), timeout);
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (gitCommit != null) {
                gitCommit.close();
            }
        }
    }

    @Override
    public String commitPath(CommitBuilder commit, Path path) {
        return this.commitPath(commit, path, 600000L);
    }

    public String commitPath(CommitBuilder commit, Path path, long timeout) {
        commit.validate();
        GitCommitJar gitCommit = null;
        if (!path.exists()) {
            throw new ConfigException(L.l("'{0}' is not an existing path for deploy commit.", (Object)path));
        }
        try {
            gitCommit = GitCommitJar.createDirectory(path);
            String tag = commit.getId();
            String string = this.deployJar(tag, gitCommit, commit.getAttributes(), timeout);
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException(e);
        }
        finally {
            if (gitCommit != null) {
                gitCommit.close();
            }
        }
    }

    public Boolean copyTag(CommitBuilder target, CommitBuilder source) {
        target.validate();
        source.validate();
        String targetId = target.getId();
        String sourceId = source.getId();
        return this._deployProxy.copyTag(targetId, sourceId, target.getAttributes());
    }

    @Override
    public boolean removeTag(CommitBuilder commit) {
        commit.validate();
        String tag = commit.getId();
        return this._deployProxy.removeTag(tag, commit.getAttributes());
    }

    public String getTagState(String tag) {
        DeployTagStateQuery query = this._deployProxy.getTagState(tag);
        if (query != null) {
            return query.getState();
        }
        return null;
    }

    public Throwable getTagException(String tag) {
        DeployTagStateQuery query = this._deployProxy.getTagState(tag);
        if (query != null) {
            return query.getThrowable();
        }
        return null;
    }

    private String deployJar(String tag, GitCommitJar commit, Map<String, String> attributes, long timeout) throws IOException {
        String[] files = this.getCommitList(commit.getCommitList());
        SendQueryCallback cb = new SendQueryCallback(files, commit);
        for (int i = 0; !cb.isEmpty() && i < 16; ++i) {
            cb.sendNext();
        }
        cb.waitForDone(timeout);
        this.putTag(tag, commit.getDigest(), attributes);
        return commit.getDigest();
    }

    public void sendFile(String sha1, long length, InputStream is) throws IOException {
        InputStream blobIs = GitCommitTree.writeBlob(is, length);
        this.writeRawGitFile(sha1, blobIs);
    }

    public void writeRawGitFile(String sha1, InputStream is) throws IOException {
        InputStreamSource iss = new InputStreamSource(is);
        StreamSource source = new StreamSource((StreamSource)iss);
        QueryFutureCallback future = new QueryFutureCallback();
        this._deployProxy.sendFile(sha1, source, future);
    }

    public String[] getCommitList(String[] commitList) {
        try {
            return this._deployProxy.getCommitList(commitList);
        }
        catch (ServiceUnavailableException e) {
            throw new ServiceUnavailableException(L.l("Deploy service is not available.\n  Ensure <resin:AdminServices> or a <resin:DeployService> is enabled in resin.xml.\n  {0}", (Object)e.getMessage()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFile(String tagName, String fileName, OutputStream os) throws IOException {
        StreamSource fileSource = this._deployProxy.getFile(tagName, fileName);
        if (fileSource != null) {
            ReadStream is = null;
            GitObjectStream gitIs = new GitObjectStream(fileSource.getInputStream());
            try {
                is = Vfs.openRead((InputStream)gitIs);
                is.writeToStream(os);
            }
            finally {
                gitIs.close();
                IoUtil.close((InputStream)is);
            }
            return true;
        }
        return false;
    }

    public String[] listFiles(String tagName, String fileName) throws IOException {
        return this._deployProxy.listFiles(tagName, fileName);
    }

    public String calculateFileDigest(InputStream is, long length) throws IOException {
        return GitCommitTree.calculateBlobDigest(is, length);
    }

    private boolean putTag(String tag, String contentHash, Map<String, String> attributes) {
        if (tag == null) {
            throw new NullPointerException();
        }
        if (contentHash == null) {
            throw new NullPointerException();
        }
        HashMap<String, String> attributeCopy = attributes != null ? new HashMap<String, String>(attributes) : new HashMap();
        return this._deployProxy.putTag(tag, contentHash, attributeCopy);
    }

    public DeployTagResult[] queryTags(String pattern) {
        return this._deployProxy.queryTags(pattern);
    }

    public boolean undeploy(CommitBuilder commit) {
        return this.removeTag(commit);
    }

    public DeployControllerState restart(String tag) {
        return this._deployProxy.restart(tag);
    }

    public DeployControllerState restartCluster(String tag) {
        return this._deployProxy.restartCluster(tag);
    }

    public DeployControllerState start(String tag) {
        return this._deployProxy.start(tag);
    }

    public DeployControllerState stop(String tag) {
        return this._deployProxy.stop(tag);
    }

    public void close() {
        this._bamClient.close();
    }

    public String toString() {
        if (this._broker != null) {
            return this.getClass().getSimpleName() + "[" + this._deployAddress + "]";
        }
        return this.getClass().getSimpleName() + "[" + this._bamClient + "]";
    }

    public static final void fillInVersion(CommitBuilder commit, String version) {
        String[] parts = version.split("\\.");
        if (parts.length < 2) {
            throw new ConfigException(L.l("erroneous version '{0}'. Version expected in format %d.%d[.%d[.%s]]", (Object)version));
        }
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        int micro = 0;
        if (parts.length > 2) {
            micro = Integer.parseInt(parts[2]);
        }
        String qualifier = null;
        if (parts.length == 4) {
            qualifier = parts[3];
        }
        commit.version(major, minor, micro, qualifier);
    }

    @Override
    public void addListener(String tagName, RepositoryTagListener listener) {
    }

    @Override
    public String getTagContentHash(String tag) {
        return null;
    }

    @Override
    public void removeListener(String tagName, RepositoryTagListener listener) {
    }

    @Override
    public Map<String, RepositoryTagEntry> getTagMap() {
        return null;
    }

    class SendQueryCallback
    implements QueryCallback {
        private ArrayList<String> _list;
        private BamError _error;
        private GitCommitJar _commit;
        private AtomicInteger _inProgressCount = new AtomicInteger();
        private AtomicLong _lastUpdate = new AtomicLong();
        private volatile boolean _isDone;

        SendQueryCallback(String[] hashList, GitCommitJar commit) {
            this._list = new ArrayList();
            for (String hash : hashList) {
                this._list.add(hash);
            }
            this._commit = commit;
        }

        @Override
        public void onQueryError(String to, String from, Serializable payload, BamError error) {
            if (this._error == null) {
                this._error = error;
            }
            this.onDone();
        }

        @Override
        public void onQueryResult(String to, String from, Serializable payload) {
            this._lastUpdate.set(CurrentTime.getCurrentTimeActual());
            this.sendNext();
            this._inProgressCount.decrementAndGet();
            if (this._inProgressCount.get() == 0) {
                this.onDone();
            }
        }

        boolean isEmpty() {
            return this._list.isEmpty();
        }

        boolean isDone() {
            return this._isDone || this._inProgressCount.get() == 0 && this._list.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendNext() {
            String sha1 = null;
            ArrayList<String> arrayList = this._list;
            synchronized (arrayList) {
                if (this._list.size() > 0) {
                    this._inProgressCount.incrementAndGet();
                    sha1 = this._list.remove(0);
                }
            }
            if (sha1 == null) {
                if (this._inProgressCount.get() == 0) {
                    this.onDone();
                }
                return;
            }
            boolean isValid = false;
            try {
                GitJarStreamSource gitSource = new GitJarStreamSource(sha1, this._commit);
                StreamSource source = new StreamSource((StreamSource)gitSource);
                DeployClient.this._deployProxy.sendFile(sha1, source, this);
                isValid = true;
            }
            finally {
                if (!isValid) {
                    this.onDone();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onDone() {
            SendQueryCallback sendQueryCallback = this;
            synchronized (sendQueryCallback) {
                this._isDone = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitForDone(long timeout) {
            this._lastUpdate.set(CurrentTime.getCurrentTimeActual());
            SendQueryCallback sendQueryCallback = this;
            synchronized (sendQueryCallback) {
                long delta;
                while (!this.isDone() && (delta = this.getTimeDelta(timeout)) > 0L) {
                    try {
                        Thread.interrupted();
                        this.wait(delta);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this._error != null) {
                throw this._error.createException();
            }
            return this._isDone;
        }

        private long getTimeDelta(long timeout) {
            return this._lastUpdate.get() + timeout - CurrentTime.getCurrentTimeActual();
        }
    }
}

