/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.cluster;

import com.caucho.cloud.network.ClusterServer;
import com.caucho.cloud.topology.CloudClusterAdmin;
import com.caucho.config.ConfigException;
import com.caucho.config.SchemaBean;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.management.server.ClusterMXBean;
import com.caucho.server.cluster.ClusterPod;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.resin.Resin;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public abstract class Cluster
implements EnvironmentListener,
SchemaBean {
    private static final L10N L = new L10N(Cluster.class);
    private static final Logger log = Logger.getLogger(Cluster.class.getName());
    private String _id = "";
    private Resin _resin;
    private CloudClusterAdmin _admin;
    private ArrayList<ContainerProgram> _serverDefaultList = new ArrayList();
    private ContainerProgram _serverProgram = new ContainerProgram();
    private final Lifecycle _lifecycle = new Lifecycle();

    protected Cluster(Resin resin) {
        if (resin == null) {
            throw new NullPointerException(L.l("resin argument is required"));
        }
        this._resin = resin;
    }

    public void setId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public Resin getResin() {
        return this._resin;
    }

    public ServletService getServer() {
        return this.getResin().getServer();
    }

    public String getSchema() {
        return "com/caucho/server/resin/cluster.rnc";
    }

    public void setDynamicServerEnable(boolean isEnable) {
        log.warning(L.l("{0}: dynamic-server-enable requires Resin Professional", (Object)this));
    }

    public boolean isDynamicServerEnable() {
        return false;
    }

    public long getVersion() {
        return 0L;
    }

    public ClusterMXBean getAdmin() {
        return this._admin;
    }

    public abstract ClusterPod[] getPodList();

    public ClusterServer findServer(String id) {
        for (ClusterPod pod : this.getPodList()) {
            ClusterServer server = pod.findServer(id);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public ClusterServer findServer(int podIndex, int index) {
        for (ClusterPod pod : this.getPodList()) {
            if (pod.getIndex() != podIndex) continue;
            for (ClusterServer server : pod.getServerList()) {
                if (server.getIndex() != index) continue;
                return server;
            }
            return null;
        }
        return null;
    }

    public ClusterPod findPod(int podIndex) {
        for (ClusterPod pod : this.getPodList()) {
            if (pod.getIndex() != podIndex) continue;
            return pod;
        }
        return null;
    }

    public ClusterServer findServerByPrefix(String prefix) {
        for (ClusterPod pod : this.getPodList()) {
            ClusterServer server = pod.findServerByPrefix(prefix);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public ClusterServer findServer(String address, int port) {
        for (ClusterPod pod : this.getPodList()) {
            ClusterServer server = pod.findServer(address, port);
            if (server == null) continue;
            return server;
        }
        return null;
    }

    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultList.add(program);
    }

    public ClusterPod createPod() {
        throw new UnsupportedOperationException(L.l("<pod> requires Resin Professional"));
    }

    public abstract ClusterServer createServer();

    public void addServer(ClusterServer server) {
    }

    protected void configureServerDefault(ClusterServer server) {
        for (int i = 0; i < this._serverDefaultList.size(); ++i) {
            this._serverDefaultList.get(i).configure((Object)server);
        }
    }

    public void addDynamicServer(String serverId, String address, int port) throws ConfigException {
        throw new UnsupportedOperationException(L.l("{0}: dynamic servers require Resin Professional", (Object)this));
    }

    protected void setSelfServer(ClusterServer server) {
    }

    public void removeDynamicServer(ClusterServer server) throws ConfigException {
        throw new UnsupportedOperationException(L.l("{0}: dynamic servers require Resin Professional", (Object)this));
    }

    public void addContentProgram(ConfigProgram program) {
        this._serverProgram.addProgram(program);
    }

    public boolean isActive() {
        return this._lifecycle.isActive();
    }

    @PostConstruct
    public void init() throws ConfigException {
        this._lifecycle.toInit();
        for (ClusterPod pod : this.getPodList()) {
            pod.init();
        }
    }

    public void start() throws ConfigException {
        this._lifecycle.toActive();
        for (ClusterPod pod : this.getPodList()) {
            pod.start();
        }
    }

    public void classLoaderInit(DynamicClassLoader loader) {
    }

    public void classLoaderDestroy(DynamicClassLoader loader) {
    }

    public void startRemote() {
    }

    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    public void environmentBind(EnvironmentClassLoader loader) {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        try {
            this.close();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        for (ClusterPod pod : this.getPodList()) {
            try {
                if (pod == null) continue;
                pod.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }

    public class ClusterVar {
        public String getId() {
            return Cluster.this._id;
        }

        public Path getRoot() {
            return ServletService.getCurrent().getRootDirectory();
        }

        public Path getRootDir() {
            return this.getRoot();
        }

        public Path getRootDirectory() {
            return this.getRoot();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this.getId() + "]";
        }
    }
}

