/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.server.admin;

import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.program.PropertyValueProgram;
import com.caucho.config.types.RawString;
import com.caucho.server.admin.Management;
import com.caucho.server.admin.ManagementServlet;
import com.caucho.server.dispatch.ServletMapping;
import com.caucho.server.hmux.HmuxRequest;
import com.caucho.server.host.HostConfig;
import com.caucho.server.security.AbstractConstraint;
import com.caucho.server.security.AuthorizationResult;
import com.caucho.server.security.SecurityConstraint;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.util.InetNetwork;
import com.caucho.util.L10N;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ManagementService {
    private static final L10N L = new L10N(ManagementService.class);
    protected final Logger log = Logger.getLogger(this.getClass().getName());
    private final Management _management;
    private final String _serviceName;
    private InetNetwork[] _allowedNetworks;

    protected ManagementService(Management management, String serviceName) {
        this._management = management;
        this._serviceName = serviceName;
    }

    public void start() {
        HostConfig hostConfig = this._management.getHostConfig();
        WebAppConfig webAppConfig = new WebAppConfig();
        webAppConfig.setId(this._serviceName);
        webAppConfig.setRootDirectory(new RawString("memory:/admin-dummy-root"));
        hostConfig.addBuilderProgram((ConfigProgram)new PropertyValueProgram("web-app", (Object)webAppConfig));
        ServletMapping servlet = new ServletMapping();
        servlet.setServletName(this._serviceName);
        servlet.addURLPattern("/*");
        servlet.addURLRegexp(".*");
        servlet.setServletClass(ManagementServlet.class.getName());
        ContainerProgram servletInit = new ContainerProgram();
        servletInit.addProgram((ConfigProgram)new PropertyValueProgram("service", (Object)this));
        servlet.setInit(servletInit);
        webAppConfig.addBuilderProgram((ConfigProgram)new PropertyValueProgram("servlet-mapping", (Object)servlet));
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.addURLPattern("/*");
        constraint.addConstraint(new HmuxConstraint(this));
        constraint.init();
        webAppConfig.addBuilderProgram((ConfigProgram)new PropertyValueProgram("security-constraint", (Object)constraint));
        try {
            this._allowedNetworks = new InetNetwork[]{new InetNetwork(InetAddress.getByName("127.0.0.1"), 24), new InetNetwork(InetAddress.getByName("10.0.0.0"), 24), new InetNetwork(InetAddress.getByName("172.16.0.0"), 20), new InetNetwork(InetAddress.getByName("192.168.0.0"), 16)};
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
        HttpServletResponse res = response;
        if (!(request instanceof HmuxRequest)) {
            this.log.warning(L.l("{0} attempt with non-hmux-request '{1}' from ip {2}", (Object)this._serviceName, (Object)request, (Object)request.getRemoteAddr()));
            res.sendError(404);
            return false;
        }
        HmuxRequest hmuxRequest = (HmuxRequest)request;
        if (!request.getServletPath().equals("")) {
            this.log.warning(L.l("{0} attempt with invalid servlet-path '{1}' from address '{2}'", (Object)this._serviceName, (Object)request.getServletPath(), (Object)request.getRemoteAddr()));
            res.sendError(404);
            return false;
        }
        if (request.getPathInfo() != null) {
            this.log.warning(L.l("{0} attempt with invalid path-info '{1}' from address '{2}'", (Object)this._serviceName, (Object)request.getPathInfo(), (Object)request.getRemoteAddr()));
            res.sendError(404);
            return false;
        }
        String remoteAddr = hmuxRequest.getRemoteAddr();
        boolean isValidAddr = false;
        for (int i = 0; i < this._allowedNetworks.length; ++i) {
            if (!this._allowedNetworks[i].isMatch(remoteAddr)) continue;
            isValidAddr = true;
        }
        if (!isValidAddr) {
            this.log.warning(L.l("{0} attempt from invalid address '{1}'", (Object)this._serviceName, (Object)remoteAddr));
            res.sendError(404);
            return false;
        }
        return true;
    }

    private boolean isRequestAllowed(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        HttpServletResponse res = (HttpServletResponse)response;
        Enumeration attributeNames = request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attributeName = (String)attributeNames.nextElement();
            if (attributeName.equals("javax.servlet.request.X509Certificate")) continue;
            this.log.warning(L.l("management service request attribute '{0}' invalidates request", (Object)attributeName));
            res.sendError(404);
            return false;
        }
        return true;
    }

    protected boolean isReadAllowed(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        return this.isRequestAllowed(request, response);
    }

    protected boolean isWriteAllowed(ServletRequest request, ServletResponse response) throws IOException, ServletException {
        return this.isRequestAllowed(request, response);
    }

    public abstract void service(ServletRequest var1, ServletResponse var2) throws IOException, ServletException;

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._serviceName + "," + this._management.getServerId() + "]";
    }

    private static class HmuxConstraint
    extends AbstractConstraint {
        private final ManagementService _service;

        public HmuxConstraint(ManagementService service) {
            this._service = service;
        }

        @Override
        public AuthorizationResult isAuthorized(HttpServletRequest request, HttpServletResponse response, ServletContext application) throws ServletException, IOException {
            if (this._service.isAuthorized(request, response, application)) {
                return AuthorizationResult.ALLOW;
            }
            return AuthorizationResult.DENY_SENT_RESPONSE;
        }
    }
}

