/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.types.InitParam;
import com.caucho.security.AbstractAuthenticator;
import com.caucho.security.PasswordCredentials;
import com.caucho.server.security.RolePrincipal;
import com.caucho.util.L10N;
import java.io.IOException;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.ServletException;

public class JaasAuthenticator
extends AbstractAuthenticator {
    private static final L10N L = new L10N(JaasAuthenticator.class);
    private static final Logger log = Logger.getLogger(JaasAuthenticator.class.getName());
    private Class<?> _loginModuleClass;
    private HashMap<String, String> _options = new HashMap();

    public JaasAuthenticator() {
        this.setPasswordDigest(null);
    }

    public void setLoginModule(Class<?> loginModuleClass) throws ConfigException {
        this._loginModuleClass = loginModuleClass;
        Config.checkCanInstantiate(loginModuleClass);
        if (!LoginModule.class.isAssignableFrom(loginModuleClass)) {
            throw new ConfigException(L.l("'{0}' must implement javax.security.auth.spi.LoginModule", (Object)loginModuleClass.getName()));
        }
    }

    public void setInitParam(InitParam init) {
        this._options.putAll(init.getParameters());
    }

    public void setOptions(InitParam init) {
        this._options.putAll(init.getParameters());
    }

    @Override
    @PostConstruct
    public void init() throws ServletException {
        super.init();
        if (this._loginModuleClass == null) {
            throw new ServletException(L.l("JaasAuthenticator requires login-module"));
        }
    }

    @Override
    protected Principal authenticate(Principal principal, PasswordCredentials cred, Object details) {
        try {
            String userName = principal.getName();
            String password = new String(cred.getPassword());
            Set<Principal> principals = this.getPrincipals(userName, password);
            if (principals == null || principals.size() == 0) {
                return null;
            }
            Principal userPrincipal = null;
            Principal roles = null;
            for (Principal loginPrincipal : principals) {
                if ("roles".equals(loginPrincipal.getName()) && loginPrincipal instanceof Group) {
                    roles = (Group)loginPrincipal;
                    continue;
                }
                if (userPrincipal != null) continue;
                userPrincipal = loginPrincipal;
            }
            if (userPrincipal == null && roles != null) {
                userPrincipal = roles;
            }
            if (userPrincipal instanceof RolePrincipal) {
                return userPrincipal;
            }
            if (userPrincipal != null) {
                return new JaasPrincipal(userPrincipal, (Group)roles);
            }
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isUserInRole(Principal principal, String role) {
        if (principal == null) {
            return false;
        }
        if (principal instanceof RolePrincipal) {
            return ((RolePrincipal)principal).isUserInRole(role);
        }
        return "user".equals(role);
    }

    private Set<Principal> getPrincipals(String userName, String password) {
        try {
            LoginModule login = (LoginModule)this._loginModuleClass.newInstance();
            Subject subject = new Subject();
            HashMap<String, String> state = new HashMap<String, String>();
            state.put("javax.security.auth.login.name", userName);
            state.put("javax.security.auth.login.password", password);
            login.initialize(subject, new Handler(userName, password), state, this._options);
            try {
                login.login();
            }
            catch (Exception e) {
                login.abort();
            }
            login.commit();
            Set<Principal> principals = subject.getPrincipals();
            return principals;
        }
        catch (LoginException e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class Handler
    implements CallbackHandler {
        private String _userName;
        private String _password;

        Handler(String userName, String password) {
            this._userName = userName;
            this._password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                Callback cb = callbacks[i];
                if (cb instanceof NameCallback) {
                    NameCallback name = (NameCallback)cb;
                    name.setName(this._userName);
                    continue;
                }
                if (!(cb instanceof PasswordCallback)) continue;
                PasswordCallback password = (PasswordCallback)cb;
                password.setPassword(this._password.toCharArray());
            }
        }
    }

    private static class JaasPrincipal
    implements RolePrincipal {
        private Principal _principal;
        private Group _roles;

        JaasPrincipal(Principal principal, Group roles) {
            this._principal = principal;
            this._roles = roles;
        }

        @Override
        public String getName() {
            return this._principal.getName();
        }

        @Override
        public boolean isUserInRole(String role) {
            if (this._roles == null) {
                return "user".equals(role);
            }
            Enumeration e = this._roles.members();
            while (e.hasMoreElements()) {
                Principal principal = (Principal)e.nextElement();
                if (!role.equals(principal.getName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._principal.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof JaasPrincipal)) {
                return false;
            }
            JaasPrincipal principal = (JaasPrincipal)obj;
            return this.getName().equals(principal.getName());
        }

        @Override
        public String toString() {
            return this._principal.toString();
        }
    }
}

