/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.security;

import com.caucho.config.Service;
import com.caucho.distcache.AbstractCache;
import com.caucho.distcache.ClusterCache;
import com.caucho.security.SingleSignon;
import java.security.Principal;
import javax.annotation.PostConstruct;
import javax.cache.Cache;

@Service
public class ClusterSingleSignon
implements SingleSignon {
    private AbstractCache _cacheConfig = new ClusterCache();
    private Cache _cache;

    public ClusterSingleSignon() {
        this("resin:single-signon");
    }

    public ClusterSingleSignon(String name) {
        this._cacheConfig.setName("resin:single-signon:" + name);
        this._cacheConfig.setModifiedExpireTimeoutMillis(86400000L);
        this._cacheConfig.setName("resin:single-signon:" + name);
    }

    public void setName(String name) {
        this._cacheConfig.setName("resin:single-signon:" + name);
    }

    @PostConstruct
    public void init() {
        this._cache = this._cacheConfig.createIfAbsent();
    }

    @Override
    public Principal get(String id) {
        return (Principal)this._cache.get((Object)id);
    }

    @Override
    public void put(String id, Principal user) {
        this._cache.put((Object)id, (Object)user);
    }

    @Override
    public boolean remove(String id) {
        this._cache.remove((Object)id);
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cache + "]";
    }
}

