/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.rewrite;

import com.caucho.config.Configurable;
import com.caucho.rewrite.AbstractDispatchRule;
import com.caucho.server.dispatch.ForwardFilterChain;
import com.caucho.server.dispatch.RewriteDispatchFilterChain;
import com.caucho.server.dispatch.RewriteIncludeFilterChain;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;

@Configurable
public class WelcomeFile
extends AbstractDispatchRule {
    private static final Logger log = Logger.getLogger(WelcomeFile.class.getName());
    private static final L10N L = new L10N(WelcomeFile.class);
    private static final HashSet<String> _welcomeFileResourceMap = new HashSet();
    private final WebApp _webApp;
    private ArrayList<String> _welcomeFileList = new ArrayList();

    public WelcomeFile() {
        WebApp webApp = WebApp.getCurrent();
        if (webApp == null) {
            throw new IllegalStateException(L.l("{0} must have an active {1}.", (Object)WelcomeFile.class.getSimpleName(), (Object)WebApp.class.getSimpleName()));
        }
        this._webApp = webApp;
    }

    public WelcomeFile(ArrayList<String> welcomeFile) {
        this();
        this._welcomeFileList.addAll(welcomeFile);
    }

    @Override
    public boolean isInclude() {
        return true;
    }

    @Override
    public boolean isForward() {
        return true;
    }

    public void addWelcomeFile(String welcomeFile) {
        this._welcomeFileList.add(welcomeFile);
    }

    @Override
    public String rewriteUri(String uri, String queryString) {
        return uri;
    }

    @Override
    public FilterChain map(DispatcherType type, String uri, String queryString, FilterChain next, FilterChain tail) throws ServletException {
        String welcomeUri = this.matchWelcomeFileResource(type, uri, null);
        if (welcomeUri == null) {
            return next;
        }
        if (DispatcherType.INCLUDE.equals((Object)type)) {
            return new RewriteIncludeFilterChain(next, welcomeUri);
        }
        if (DispatcherType.FORWARD.equals((Object)type)) {
            return new ForwardFilterChain(welcomeUri);
        }
        return new RewriteDispatchFilterChain(welcomeUri);
    }

    private String matchWelcomeFileResource(DispatcherType type, String uri, ArrayList<String> vars) {
        if (this.matchWelcomeUri(uri) != Match.NONE) {
            return null;
        }
        try {
            Path path = this._webApp.getCauchoPath(uri);
            if (!path.exists()) {
                return null;
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("can't match a welcome file path {0}", (Object)uri), e);
            }
            return null;
        }
        ArrayList<String> welcomeFileList = this._welcomeFileList;
        int size = welcomeFileList.size();
        String bestWelcomeUri = null;
        Match bestMatch = Match.NONE;
        for (int i = 0; i < size; ++i) {
            String welcomeUri;
            String file = welcomeFileList.get(i);
            if (uri.endsWith("/")) {
                welcomeUri = uri + file;
            } else {
                if (DispatcherType.REQUEST.equals((Object)type)) continue;
                welcomeUri = uri + '/' + file;
            }
            Match match = this.matchWelcomeUri(welcomeUri);
            if (bestMatch.ordinal() >= match.ordinal()) continue;
            bestMatch = Match.FILE;
            bestWelcomeUri = welcomeUri;
        }
        return bestWelcomeUri;
    }

    private Match matchWelcomeUri(String welcomeUri) {
        try {
            InputStream is = this._webApp.getResourceAsStream(welcomeUri);
            if (is != null) {
                is.close();
            }
            if (is != null) {
                return Match.FILE;
            }
        }
        catch (Exception e) {
            log.fine("welcome-file lookup failed: " + welcomeUri);
            log.log(Level.ALL, e.toString(), e);
        }
        String servletClassName = this._webApp.getServletMapper().getServletClassByUri(welcomeUri);
        if (servletClassName != null && !_welcomeFileResourceMap.contains(servletClassName)) {
            return Match.SERVLET;
        }
        return Match.NONE;
    }

    static {
        _welcomeFileResourceMap.add("com.caucho.servlets.FileServlet");
        _welcomeFileResourceMap.add("com.caucho.jsp.JspServlet");
        _welcomeFileResourceMap.add("com.caucho.jsp.JspXmlServlet");
        _welcomeFileResourceMap.add("com.caucho.quercus.servlet.QuercusServlet");
        _welcomeFileResourceMap.add("com.caucho.jsp.XtpServlet");
        _welcomeFileResourceMap.add("com.caucho.xtpdoc.ResinDocServlet");
    }

    static enum Match {
        NONE,
        SERVLET,
        FILE;

    }
}

