/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.resin;

import com.caucho.config.ConfigException;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.RawString;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.network.listen.StreamSocketLink;
import com.caucho.resin.BeanEmbed;
import com.caucho.resin.HttpEmbed;
import com.caucho.resin.PortEmbed;
import com.caucho.resin.WebAppEmbed;
import com.caucho.resin.WebAppLocalDeployEmbed;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.host.Host;
import com.caucho.server.host.HostConfig;
import com.caucho.server.http.HttpRequest;
import com.caucho.server.resin.Resin;
import com.caucho.server.resin.ResinArgs;
import com.caucho.server.resin.ResinEmbedded;
import com.caucho.server.webapp.WebApp;
import com.caucho.server.webapp.WebAppConfig;
import com.caucho.server.webapp.WebAppContainer;
import com.caucho.server.webapp.WebAppSingleDeployGenerator;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.VfsStream;
import com.caucho.vfs.WriteStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.logging.LogManager;
import javax.enterprise.context.spi.CreationalContext;

public class ResinEmbed {
    private static final L10N L = new L10N(ResinEmbed.class);
    private static final String EMBED_CONF = "classpath:com/caucho/resin/resin-embed.xml";
    private final ResinArgs _args;
    private Resin _resin;
    private String _configFile = "classpath:com/caucho/resin/resin-embed.xml";
    private Host _host;
    private ServletService _server;
    private String _serverHeader;
    private final ArrayList<BeanEmbed> _beanList = new ArrayList();
    private final ArrayList<WebAppEmbed> _webAppList = new ArrayList();
    private final ArrayList<PortEmbed> _portList = new ArrayList();
    private Lifecycle _lifecycle = new Lifecycle();
    private boolean _isScanRoot;
    private boolean _isConfig;
    private boolean _isDevelopmentMode;
    private boolean _isIgnoreClientDisconnect;
    private boolean _isIgnoreLock;

    public ResinEmbed() {
        this._args = new ResinArgs();
        this._args.setServerId("default");
        this._args.setRootDirectory(Vfs.lookup());
    }

    public ResinEmbed(String configFile) {
        this();
        this.setConfig(configFile);
    }

    public void setRootDirectory(String rootUrl) {
        this._args.setRootDirectory(Vfs.lookup((String)rootUrl));
    }

    public void setServerId(String id) {
        this._args.setServerId(id);
    }

    public void setConfig(String configFile) {
        this._configFile = configFile;
    }

    public void addPort(PortEmbed port) {
        this._portList.add(port);
        if (this._server != null) {
            port.bindTo(this._server);
        }
    }

    public void setPorts(PortEmbed[] ports) {
        for (PortEmbed port : ports) {
            this.addPort(port);
        }
    }

    public void setServerHeader(String serverName) {
        this._serverHeader = serverName;
    }

    public void addWebApp(WebAppEmbed webApplication) {
        if (webApplication == null) {
            throw new NullPointerException();
        }
        this._webAppList.add(webApplication);
        if (this._lifecycle.isActive()) {
            this.deployWebApplication(webApplication);
        }
    }

    public void removeWebApp(WebAppEmbed webApplication) {
        if (webApplication == null) {
            throw new NullPointerException();
        }
        this._webAppList.remove(webApplication);
        if (this._lifecycle.isActive()) {
            this.undeployWebApplication(webApplication);
        }
    }

    public void setWebApps(WebAppEmbed[] webApps) {
        for (WebAppEmbed webApp : webApps) {
            this.addWebApp(webApp);
        }
    }

    public void addBean(BeanEmbed bean) {
        this._beanList.add(bean);
        if (this._lifecycle.isActive()) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader((ClassLoader)this._server.getClassLoader());
                bean.configure();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw ConfigException.create((Throwable)e);
            }
            finally {
                thread.setContextClassLoader(oldLoader);
            }
        }
    }

    public void setDevelopmentMode(boolean isDevelopment) {
        this._isDevelopmentMode = isDevelopment;
    }

    public void setIgnoreClientDisconnect(boolean isIgnore) {
        this._isIgnoreClientDisconnect = isIgnore;
    }

    public void initializeEnvironment() {
        Environment.initializeEnvironment();
    }

    public void resetLogManager() {
        LogManager.getLogManager().reset();
    }

    public void addScanRoot() {
        this._isScanRoot = true;
    }

    public void setIgnoreLock(boolean isIgnoreLock) {
        this._isIgnoreLock = isIgnoreLock;
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            Environment.initializeEnvironment();
            this._resin = new ResinEmbedded(this._args);
            if (this._isIgnoreLock) {
                this._resin.setIgnoreLock(this._isIgnoreLock);
            }
            thread.setContextClassLoader((ClassLoader)this._resin.getClassLoader());
            if (this._isScanRoot) {
                this._resin.getClassLoader().addScanRoot();
            }
            this.initConfig(this._configFile);
            this._server = this._resin.createServer();
            thread.setContextClassLoader((ClassLoader)this._server.getClassLoader());
            if (this._serverHeader != null) {
                this._server.setServerHeader(this._serverHeader);
            }
            this._server.setDevelopmentModeErrorPage(this._isDevelopmentMode);
            this._server.setIgnoreClientDisconnect(this._isIgnoreClientDisconnect);
            for (BeanEmbed beanEmbed : this._beanList) {
                beanEmbed.configure();
            }
            for (PortEmbed port : this._portList) {
                port.bindTo(this._server);
            }
            this._resin.start();
            this._host = this._server.getHost("", 0);
            if (this._host == null) {
                HostConfig hostConfig = new HostConfig();
                this._server.addHost(hostConfig);
                this._host = this._server.getHost("", 0);
            }
            if (this._host == null) {
                throw new ConfigException(L.l("ResinEmbed requires a <host> to be configured in the resin.xml, because the webapps must belong to a host."));
            }
            for (WebAppEmbed webApplication : this._webAppList) {
                this.deployWebApplication(webApplication);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        try {
            this._resin.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void join() {
        while (!this._resin.isClosed()) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
    }

    public void destroy() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        try {
            this._resin.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public void close() {
        this.destroy();
    }

    public void request(InputStream is, OutputStream os) throws IOException {
        this.start();
        TestConnection conn = this.createConnection();
        conn.request(is, os);
    }

    public void request(String httpRequest, OutputStream os) throws IOException {
        this.start();
        TestConnection conn = this.createConnection();
        conn.request(httpRequest, os);
    }

    public String request(String httpRequest) throws IOException {
        this.start();
        TestConnection conn = this.createConnection();
        return conn.request(httpRequest);
    }

    private TestConnection createConnection() {
        TestConnection conn = new TestConnection();
        return conn;
    }

    private void initConfig(String configFile) {
        try {
            if (this._isConfig) {
                return;
            }
            this._isConfig = true;
            this._resin.configureFile(Vfs.lookup((String)configFile));
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private void deployWebApplication(WebAppEmbed webApplication) {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader((ClassLoader)this._host.getClassLoader());
            WebAppConfig configuration = new WebAppConfig();
            configuration.setContextPath(webApplication.getContextPath());
            configuration.setRootDirectory(new RawString(webApplication.getRootDirectory()));
            if (webApplication.getArchivePath() != null) {
                configuration.setArchivePath(new RawString(webApplication.getArchivePath()));
            }
            configuration.addBuilderProgram(new WebAppProgram(webApplication));
            WebAppContainer container = this._host.getWebAppContainer();
            WebAppSingleDeployGenerator deployGenerator = container.createDeployGenerator(configuration);
            webApplication.setDeployGenerator(deployGenerator);
            container.addWebApp(deployGenerator);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    private void undeployWebApplication(WebAppEmbed webApplication) {
        this._host.getWebAppContainer().removeWebApp(webApplication.getDeployGenerator());
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.destroy();
    }

    public static void main(String[] args) throws Exception {
        ResinEmbed resin = new ResinEmbed();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("--port=")) {
                int port = Integer.parseInt(args[i].substring("--port=".length()));
                HttpEmbed http = new HttpEmbed(port);
                resin.addPort(http);
                continue;
            }
            if (args[i].startsWith("--config=")) {
                String config = args[i].substring("--config=".length());
                resin.setConfig(config);
                continue;
            }
            if (!args[i].startsWith("--deploy:")) continue;
            String valueString = args[i].substring("--deploy:".length());
            String[] values = valueString.split("[=,]");
            String role = null;
            for (int j = 0; j < values.length; j += 2) {
                if (!values[j].equals("role")) continue;
                role = values[j + 1];
            }
            WebAppLocalDeployEmbed webApp = new WebAppLocalDeployEmbed();
            if (role != null) {
                webApp.setRole(role);
            }
            resin.addWebApp(webApp);
        }
        resin.resetLogManager();
        resin.start();
        resin.join();
    }

    static class WebAppProgram
    extends ConfigProgram {
        private final WebAppEmbed _config;

        WebAppProgram(WebAppEmbed webAppConfig) {
            this._config = webAppConfig;
        }

        public <T> void inject(T bean, CreationalContext<T> env) throws ConfigException {
            this._config.configure((WebApp)bean);
        }
    }

    private class TestConnection {
        StreamSocketLink _conn;
        HttpRequest _request;
        VfsStream _vfsStream;
        InetAddress _localAddress;
        InetAddress _remoteAddress;
        int _port = 6666;
        char[] _chars = new char[1024];
        byte[] _bytes = new byte[1024];

        TestConnection() {
            this._conn = new StreamSocketLink();
            this._request = new HttpRequest(ResinEmbed.this._resin.getServer(), this._conn);
            this._request.init();
            this._vfsStream = new VfsStream(null, null);
            try {
                this._localAddress = InetAddress.getByName("127.0.0.1");
                this._remoteAddress = InetAddress.getByName("127.0.0.1");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String request(String input) throws IOException {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.request(input, (OutputStream)os);
            return ((Object)os).toString();
        }

        public void request(String input, OutputStream os) throws IOException {
            int len = input.length();
            if (this._chars.length < len) {
                this._chars = new char[len];
                this._bytes = new byte[len];
            }
            input.getChars(0, len, this._chars, 0);
            for (int i = 0; i < len; ++i) {
                this._bytes[i] = (byte)this._chars[i];
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this._bytes, 0, len);
            this.request(is, os);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void request(InputStream is, OutputStream os) throws IOException {
            Thread.yield();
            WriteStream out = Vfs.openWrite((OutputStream)os);
            out.setDisableClose(true);
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            try {
                this._vfsStream.init(is, os);
                this._conn.setStream(is, os);
                this._conn.setLocalAddress(this._localAddress);
                this._conn.setLocalPort(this._port);
                this._conn.setRemoteAddress(this._remoteAddress);
                this._conn.setRemotePort(9666);
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                while (this._request.handleRequest()) {
                    out.flush();
                }
            }
            catch (EOFException eOFException) {
            }
            finally {
                out.flush();
                Thread.currentThread().setContextClassLoader(oldLoader);
            }
        }
    }
}

