/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.mysql;

import com.caucho.quercus.mysql.MysqlConnectionImpl;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.logging.Logger;

class MysqlReader {
    protected static final Logger log = Logger.getLogger(MysqlReader.class.getName());
    protected static final L10N L = new L10N(MysqlReader.class);
    private MysqlConnectionImpl _conn;
    private ReadStream _is;
    private int _packetLength;
    private int _packetNumber;
    private int _packetOffset;
    private byte[] _header = new byte[4];

    MysqlReader(MysqlConnectionImpl conn, ReadStream is) {
        this._conn = conn;
        this._is = is;
    }

    void readPacket() throws SQLException {
        try {
            int len;
            if (this._packetLength > 0) {
                this.skipToEnd();
            }
            if ((len = this._is.readAll(this._header, 0, this._header.length)) < this._header.length) {
                throw new SQLException("end of file");
            }
            this._packetLength = ((this._header[0] & 0xFF) << 0) + ((this._header[1] & 0xFF) << 8) + ((this._header[2] & 0xFF) << 16);
            this._packetNumber = this._header[3];
            this._packetOffset = 0;
            assert (this._packetOffset <= this._packetLength);
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    String readTailString() throws IOException {
        StringBuilder sb = new StringBuilder();
        int len = this.getPacketLength() - this.getPacketOffset();
        for (int i = 0; i < len; ++i) {
            int ch = this.readByte();
            if (ch <= 0) continue;
            sb.append((char)ch);
        }
        return sb.toString();
    }

    int readByte() throws IOException {
        int value = this._is.read();
        ++this._packetOffset;
        assert (this._packetOffset <= this._packetLength);
        return value;
    }

    String readNullTermString() throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        ReadStream is = this._is;
        int packetOffset = this._packetOffset;
        while ((ch = is.read()) > 0) {
            sb.append((char)ch);
            ++packetOffset;
        }
        if (ch == 0) {
            ++packetOffset;
        }
        this._packetOffset = packetOffset;
        if (ch < 0) {
            this.eof();
        }
        assert (this._packetOffset <= this._packetLength);
        return sb.toString();
    }

    int readInt() throws IOException {
        ReadStream is = this._is;
        int ch1 = is.read();
        int ch2 = is.read();
        int ch3 = is.read();
        int ch4 = is.read();
        if (ch4 < 0) {
            this.eof();
        }
        this._packetOffset += 4;
        assert (this._packetOffset <= this._packetLength);
        return (ch1 << 0) + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    int readShort() throws IOException {
        ReadStream is = this._is;
        int ch1 = is.read();
        int ch2 = is.read();
        if (ch2 < 0) {
            this.eof();
        }
        this._packetOffset += 2;
        assert (this._packetOffset <= this._packetLength);
        return (ch1 << 0) + (ch2 << 8);
    }

    long readLengthCodedBinary() throws IOException {
        ReadStream is = this._is;
        int ch = is.read();
        ++this._packetOffset;
        if (ch <= 250) {
            assert (this._packetOffset <= this._packetLength);
            return ch;
        }
        return this.readLengthCodedBinary(ch);
    }

    long readLengthCodedBinary(int ch) throws IOException {
        ReadStream is = this._is;
        if (ch <= 250) {
            return ch;
        }
        if (ch == 252) {
            this._packetOffset += 2;
            assert (this._packetOffset <= this._packetLength);
            int len = is.read() | is.read() << 8;
            return len;
        }
        if (ch == 253) {
            this._packetOffset += 3;
            assert (this._packetOffset <= this._packetLength);
            int len = is.read() | is.read() << 8 | is.read() << 16;
            return len;
        }
        if (ch == 254) {
            this._packetOffset += 8;
            assert (this._packetOffset <= this._packetLength);
            int len = is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24 | is.read() << 32 | is.read() << 40 | is.read() << 48 | is.read() << 56;
            return len;
        }
        throw new IllegalStateException();
    }

    int readAll(byte[] buffer, int offset, int length) throws IOException {
        int len = this._is.readAll(buffer, offset, length);
        if (len < length) {
            this.eof();
        }
        this._packetOffset += len;
        assert (this._packetOffset <= this._packetLength);
        return len;
    }

    int readAll(char[] buffer, int offset, int length) throws IOException {
        int len = this._is.readAll(buffer, offset, length);
        if (len < length) {
            this.eof();
        }
        this._packetOffset += len;
        assert (this._packetOffset <= this._packetLength);
        return len;
    }

    int readData(OutputStream os, int length) throws IOException {
        this._is.writeToStream(os, length);
        this._packetOffset += length;
        return length;
    }

    void skip(int length) throws IOException {
        this._is.skip((long)length);
        this._packetOffset += length;
        assert (this._packetOffset <= this._packetLength);
    }

    int getPacketOffset() {
        return this._packetOffset;
    }

    int getPacketLength() {
        return this._packetLength;
    }

    private void eof() throws IOException {
        throw new IOException("unexpected end of file");
    }

    void endPacket() throws SQLException {
        this.skipToEnd();
    }

    private void skipToEnd() throws SQLException {
        try {
            int len = this._packetLength - this._packetOffset;
            this._is.skip((long)len);
            this._packetOffset = 0;
            this._packetLength = 0;
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public void close() {
        ReadStream is = this._is;
        this._is = null;
        IoUtil.close((InputStream)is);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._is + "]";
    }
}

