/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.session;

import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.SessionArrayValue;
import com.caucho.quercus.lib.session.QuercusSessionManager;
import com.caucho.quercus.servlet.api.QuercusHttpServletRequest;
import com.caucho.server.cluster.ServletService;
import com.caucho.server.session.SessionManager;
import com.caucho.server.webapp.WebApp;
import com.caucho.util.L10N;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ProSessionManager
extends QuercusSessionManager {
    protected static final L10N L = new L10N(ProSessionManager.class);
    protected static final Logger log = Logger.getLogger(ProSessionManager.class.getName());
    private WebApp _webApp = WebApp.getLocal();
    private SessionManager _sessionManager;

    public ProSessionManager(QuercusContext quercus, String contextId) {
        super(quercus);
        if (this._webApp != null) {
            this._sessionManager = this._webApp.getSessionManager();
        }
        if (this._sessionManager != null) {
            this.setSessionTimeout(this._sessionManager.getSessionTimeout());
        }
        ServletService server = ServletService.getCurrent();
    }

    public String createSessionId(Env env) {
        QuercusHttpServletRequest request;
        String id;
        if (this._sessionManager == null) {
            return super.createSessionId(env);
        }
        while (this.getSession(env, id = this._sessionManager.createSessionIdImpl((HttpServletRequest)(request = env.getRequest()).toRequest(HttpServletRequest.class)), 0L) != null) {
        }
        if (id == null || id.equals("")) {
            throw new RuntimeException();
        }
        return id;
    }

    public long getMaxIdleTime() {
        return this._sessionManager.getMaxIdleTime();
    }

    public void load(InputStream in, Object obj) throws IOException {
        SessionArrayValue session = (SessionArrayValue)obj;
        session.load(Env.getInstance(), in);
    }

    public boolean isEmpty(Object obj) {
        SessionArrayValue session = (SessionArrayValue)obj;
        return session.isEmpty();
    }

    public void notifyRemove(Object id) {
        SessionArrayValue session = (SessionArrayValue)this._sessions.remove((Object)((String)id));
        if (session != null) {
            session.invalidate();
        }
    }

    public void notifyUpdate(Object id) {
    }

    public void store(OutputStream out, Object obj) throws IOException {
        SessionArrayValue session = (SessionArrayValue)obj;
        session.store(Env.getInstance(), out);
    }
}

