/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.quercus.lib.bam;

import com.caucho.bam.broker.Broker;
import com.caucho.config.ConfigException;
import com.caucho.hemp.broker.HempBroker;
import com.caucho.quercus.QuercusContext;
import com.caucho.quercus.ResinQuercus;
import com.caucho.quercus.env.BooleanValue;
import com.caucho.quercus.env.Env;
import com.caucho.quercus.env.StringValue;
import com.caucho.quercus.env.Value;
import com.caucho.quercus.lib.bam.BamPhpActor;
import com.caucho.quercus.page.QuercusPage;
import com.caucho.quercus.program.JavaClassDef;
import com.caucho.quercus.program.QuercusProgram;
import com.caucho.util.L10N;
import com.caucho.vfs.NullWriteStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class BamPhpServiceManager {
    private static final L10N L = new L10N(BamPhpServiceManager.class);
    private static final Logger log = Logger.getLogger(BamPhpServiceManager.class.getName());
    private final QuercusContext _quercus = new ResinQuercus();
    private final HashMap<String, BamPhpActor> _children = new HashMap();
    private ArrayList<String> _featureNames = new ArrayList();
    private QuercusProgram _program;
    private Path _script;
    private String _encoding = "ISO-8859-1";
    Broker _broker = HempBroker.getCurrent();

    public BamPhpServiceManager() {
    }

    public BamPhpServiceManager(Path script, String encoding) {
        this._script = script;
        this._encoding = encoding;
    }

    public Path getScript() {
        return this._script;
    }

    public void setScript(Path script) {
        this._script = script;
    }

    public String getEncoding() {
        return this._encoding;
    }

    public void setEncoding(String encoding) {
        this._encoding = encoding;
    }

    Broker getBroker() {
        return this._broker;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._script == null) {
            throw new ConfigException(L.l("script path not specified"));
        }
        this._quercus.init();
        this._quercus.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean startActor(String address) {
        Env env = null;
        boolean started = false;
        try {
            QuercusPage page = this._quercus.parse(this._script);
            env = this.createEnv(page, "_quercus_bam_start_service", address);
            page.executeTop(env);
            started = env.getGlobalValue("_quercus_bam_function_return").toBoolean();
            return started;
        }
        finally {
            if (env != null) {
                env.close();
            }
            return started;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopActor(String address) {
        Env env = null;
        boolean stoped = false;
        try {
            QuercusPage page = this._quercus.parse(this._script);
            env = this.createEnv(page, "_quercus_bam_stop_service", address);
            page.executeTop(env);
            stoped = env.getGlobalValue("_quercus_bam_function_return").toBoolean();
            return stoped;
        }
        finally {
            if (env != null) {
                env.close();
            }
            return stoped;
        }
    }

    boolean hasChild(String address) {
        return this._children.containsKey(address);
    }

    BamPhpActor removeChild(String address) {
        return this._children.remove(address);
    }

    void addChild(String address, BamPhpActor child) {
        this._children.put(address, child);
    }

    private Env createEnv(QuercusPage page, String type, String address) {
        NullWriteStream out = new NullWriteStream();
        Env env = new Env(this._quercus, page, (WriteStream)out, null, null);
        env.start();
        JavaClassDef actorClassDef = env.getJavaClassDefinition(BamPhpServiceManager.class);
        env.setGlobalValue("_quercus_bam_service_manager", actorClassDef.wrap(env, (Object)this));
        env.setGlobalValue(type, (Value)BooleanValue.TRUE);
        env.setGlobalValue("_quercus_bam_service_address", StringValue.create((String)address));
        return env;
    }

    public String toString() {
        return "BamPhpServiceManager[script=" + this._script + "]";
    }
}

