/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.proxy;

import com.caucho.cloud.loadbalance.LoadBalanceManager;
import com.caucho.network.balance.ClientSocket;
import com.caucho.network.proxy.ProxyResult;
import com.caucho.server.http.CauchoRequest;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxyClient {
    private static final Logger log = Logger.getLogger(HttpProxyClient.class.getName());
    private static final L10N L = new L10N(HttpProxyClient.class);
    private LoadBalanceManager _loadBalancer;

    public HttpProxyClient(LoadBalanceManager loadBalancer) {
        this._loadBalancer = loadBalancer;
    }

    protected LoadBalanceManager getLoadBalancer() {
        return this._loadBalancer;
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) {
        String sessionId = this.getSessionId(req);
        ClientSocket client = this.getLoadBalancer().openSticky(sessionId, req, null);
        if (client == null) {
            this.proxyFailure(req, res, null, "no backend servers available", true);
            return;
        }
        String uri = this.constructURI(req);
        long requestStartTime = System.currentTimeMillis();
        ProxyResult result = this.proxy(req, res, uri, sessionId, client);
        if (!result.isSuccess()) {
            this.proxyFailure(req, res, null, result.getFailureMessage(), true);
        }
        if (result.isKeepAlive()) {
            client.free(requestStartTime);
        } else {
            client.close();
        }
    }

    protected void proxyFailure(HttpServletRequest req, HttpServletResponse res, ClientSocket client, String reason, boolean send503) {
        log.warning(L.l("{0}: proxy {1} failed for {2}: {3}", (Object)this, client != null ? client : "", (Object)req.getRequestURI(), (Object)reason));
        if (res.isCommitted()) {
            return;
        }
        if (send503) {
            try {
                res.sendError(503);
            }
            catch (IOException e) {
                log.log(Level.FINE, L.l("{0}: failed to send error {1}: {2}", (Object)this, (Object)req.getRequestURI(), (Object)e.getMessage()), e);
            }
        }
    }

    protected ProxyResult proxy(HttpServletRequest req, HttpServletResponse res, String uri, String sessionId, ClientSocket client) {
        ReadStream clientIn = client.getInputStream();
        WriteStream clientOut = client.getOutputStream();
        try {
            int len;
            clientOut.print(req.getMethod());
            clientOut.print(' ');
            clientOut.print(uri);
            clientOut.print(" HTTP/1.1\r\n");
            String host = req.getHeader("Host");
            if (host == null) {
                host = req.getServerName() + ":" + req.getServerPort();
            }
            clientOut.print("Host: ");
            clientOut.print(host);
            clientOut.print("\r\n");
            clientOut.print("X-Forwarded-For: ");
            clientOut.print(req.getRemoteAddr());
            clientOut.print("\r\n");
            Enumeration e = req.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (name.equalsIgnoreCase("Connection") || name.equalsIgnoreCase("Host")) continue;
                Enumeration e1 = req.getHeaders(name);
                while (e1.hasMoreElements()) {
                    String value = (String)e1.nextElement();
                    clientOut.print(name);
                    clientOut.print(": ");
                    clientOut.print(value);
                    clientOut.print("\r\n");
                }
            }
            int contentLength = req.getContentLength();
            ServletInputStream is = req.getInputStream();
            TempBuffer tempBuffer = TempBuffer.allocate();
            byte[] buffer = tempBuffer.getBuffer();
            boolean isFirst = true;
            if (contentLength >= 0) {
                isFirst = false;
                clientOut.print("\r\n");
            }
            while ((len = is.read(buffer, 0, buffer.length)) > 0) {
                if (isFirst) {
                    clientOut.print("Transfer-Encoding: chunked\r\n");
                }
                if (contentLength < 0) {
                    clientOut.print("\r\n");
                    clientOut.print(Integer.toHexString(len));
                    clientOut.print("\r\n");
                }
                clientOut.write(buffer, 0, len);
                isFirst = false;
            }
            if (isFirst) {
                clientOut.print("Content-Length: 0\r\n\r\n");
            } else if (contentLength < 0) {
                clientOut.print("\r\n0\r\n");
            }
            TempBuffer.free((TempBuffer)tempBuffer);
            clientOut.flush();
            return this.parseResults(clientIn, req, res);
        }
        catch (Exception e) {
            return new ProxyResult(ProxyResult.ProxyStatus.FAIL, false, e.toString());
        }
    }

    protected String constructURI(HttpServletRequest req) {
        String uri = req.isRequestedSessionIdFromURL() ? req.getRequestURI() + ";jsessionid=" + req.getRequestedSessionId() : req.getRequestURI();
        String queryString = null;
        if (req instanceof CauchoRequest) {
            queryString = ((CauchoRequest)req).getPageQueryString();
        } else {
            queryString = (String)req.getAttribute("javax.servlet.include.query_string");
            if (queryString == null) {
                queryString = req.getQueryString();
            }
        }
        if (queryString != null) {
            uri = uri + '?' + queryString;
        }
        return uri;
    }

    protected String getSessionId(HttpServletRequest req) {
        return req.getRequestedSessionId();
    }

    private ProxyResult parseResults(ReadStream is, HttpServletRequest req, HttpServletResponse res) throws IOException {
        int p;
        String line = this.parseStatus(is);
        if (line.length() == 0) {
            return new ProxyResult(ProxyResult.ProxyStatus.FAIL, false, "read failure");
        }
        boolean isKeepalive = true;
        if (!line.startsWith("HTTP/1.1")) {
            isKeepalive = false;
        }
        int statusCode = this.parseStatusCode(line);
        String location = null;
        boolean isChunked = false;
        int contentLength = -1;
        while ((line = is.readLine()) != null && (p = line.indexOf(58)) >= 0) {
            String name = line.substring(0, p);
            String value = line.substring(p + 1).trim();
            if (name.equalsIgnoreCase("transfer-encoding")) {
                isChunked = true;
                continue;
            }
            if (name.equalsIgnoreCase("content-length")) {
                contentLength = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("location")) {
                location = value;
                continue;
            }
            if (name.equalsIgnoreCase("connection")) {
                if (!"close".equalsIgnoreCase(value)) continue;
                isKeepalive = false;
                continue;
            }
            res.addHeader(name, value);
        }
        if (location != null) {
            res.setHeader("Location", location);
        }
        ProxyResult.ProxyStatus resultStatus = ProxyResult.ProxyStatus.OK;
        if (statusCode == 302 && location != null) {
            res.sendRedirect(location);
        } else if (statusCode != 200) {
            res.setStatus(statusCode);
        }
        if (statusCode == 503) {
            resultStatus = ProxyResult.ProxyStatus.BUSY;
            isKeepalive = false;
        }
        ServletOutputStream os = res.getOutputStream();
        if (isChunked) {
            this.writeChunkedData((OutputStream)os, is);
        } else if (contentLength > 0) {
            res.setContentLength(contentLength);
            this.writeContentLength((OutputStream)os, is, contentLength);
        }
        return new ProxyResult(resultStatus, isKeepalive);
    }

    private String parseStatus(ReadStream is) throws IOException {
        int ch = is.read();
        while (Character.isWhitespace(ch)) {
            ch = is.read();
        }
        StringBuilder sb = new StringBuilder();
        while (ch >= 0 && ch != 10) {
            if (ch != 13) {
                sb.append((char)ch);
            }
            ch = is.read();
        }
        return sb.toString();
    }

    private int parseStatusCode(String line) {
        char ch;
        int i;
        int len = line.length();
        for (i = 0; i < len && (ch = line.charAt(i)) != ' '; ++i) {
        }
        while (i < len && (ch = line.charAt(i)) == ' ') {
            ++i;
        }
        int statusCode = 0;
        while (i < len && '0' <= (ch = line.charAt(i)) && ch <= '9') {
            statusCode = 10 * statusCode + ch - 48;
            ++i;
        }
        if (statusCode == 0) {
            return 400;
        }
        return statusCode;
    }

    private void writeChunkedData(OutputStream os, ReadStream is) throws IOException {
        int ch;
        while (true) {
            ch = is.read();
            while (Character.isWhitespace(ch)) {
                ch = is.read();
            }
            int len = 0;
            while (ch >= 0) {
                if (48 <= ch && ch <= 57) {
                    len = 16 * len + ch - 48;
                } else if (97 <= ch && ch <= 102) {
                    len = 16 * len + ch - 97 + 10;
                } else {
                    if (65 > ch || ch > 70) break;
                    len = 16 * len + ch - 65 + 10;
                }
                ch = is.read();
            }
            if (ch == 13) {
                ch = is.read();
            }
            if (ch != 10) {
                throw new IllegalStateException(L.l("unexpected chunking at '{0}'", (long)((char)ch)));
            }
            if (len == 0) break;
            is.writeToStream(os, len);
        }
        ch = is.read();
        if (ch == 13) {
            ch = is.read();
        }
    }

    private void writeContentLength(OutputStream os, ReadStream is, int length) throws IOException {
        is.writeToStream(os, length);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

