/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.PortMXBean;
import com.caucho.management.server.TcpConnectionInfo;
import com.caucho.network.listen.TcpPort;

@Module
public class TcpPortAdmin
extends AbstractManagedObject
implements PortMXBean {
    private TcpPort _port;

    public TcpPortAdmin(TcpPort port) {
        this._port = port;
    }

    public String getName() {
        String addr = this._port.getAddress();
        if (addr == null) {
            addr = "INADDR_ANY";
        }
        return addr + '-' + this._port.getPort();
    }

    @Override
    public String getProtocolName() {
        return this._port.getProtocolName();
    }

    @Override
    public String getAddress() {
        return this._port.getAddress();
    }

    @Override
    public int getPort() {
        return this._port.getPort();
    }

    @Override
    public boolean isSSL() {
        return this._port.isSSL();
    }

    @Override
    public int getAcceptThreadMin() {
        return this._port.getAcceptThreadMin();
    }

    @Override
    public int getAcceptThreadMax() {
        return this._port.getAcceptThreadMax();
    }

    @Override
    public int getAcceptListenBacklog() {
        return this._port.getAcceptListenBacklog();
    }

    @Override
    public int getConnectionMax() {
        return this._port.getConnectionMax();
    }

    @Override
    public int getPortThreadMax() {
        return this._port.getPortThreadMax();
    }

    @Override
    public int getKeepaliveMax() {
        return this._port.getKeepaliveMax();
    }

    @Override
    public int getKeepaliveSelectMax() {
        return this._port.getKeepaliveSelectMax();
    }

    @Override
    public long getKeepaliveConnectionTimeMax() {
        return this._port.getKeepaliveConnectionTimeMax();
    }

    @Override
    public long getKeepaliveThreadTimeout() {
        return this._port.getKeepaliveThreadTimeout();
    }

    @Override
    public long getKeepaliveTimeout() {
        return this._port.getKeepaliveTimeout();
    }

    @Override
    public long getSocketTimeout() {
        return this._port.getSocketTimeout();
    }

    @Override
    public boolean isTcpKeepalive() {
        return this._port.isTcpKeepalive();
    }

    @Override
    public boolean isTcpNoDelay() {
        return this._port.isTcpNoDelay();
    }

    @Override
    public long getSuspendTimeMax() {
        return this._port.getSuspendTimeMax();
    }

    @Override
    public String getState() {
        return this._port.getLifecycleState().getStateName();
    }

    @Override
    public int getThreadCount() {
        return this._port.getThreadCount();
    }

    @Override
    public int getThreadActiveCount() {
        return this._port.getActiveThreadCount();
    }

    @Override
    public int getThreadIdleCount() {
        return this._port.getIdleThreadCount();
    }

    @Override
    public int getThreadStartCount() {
        return this._port.getStartThreadCount();
    }

    @Override
    public boolean isJniEnabled() {
        return this._port.isJniEnabled();
    }

    @Override
    public int getKeepaliveCount() {
        return this._port.getKeepaliveConnectionCount();
    }

    @Override
    public int getKeepaliveThreadCount() {
        return this._port.getKeepaliveThreadCount();
    }

    @Override
    public int getKeepaliveSelectCount() {
        return this._port.getSelectConnectionCount();
    }

    @Override
    public int getCometIdleCount() {
        return this._port.getCometIdleCount();
    }

    @Override
    public long getRequestCountTotal() {
        return this._port.getLifetimeRequestCount();
    }

    @Override
    public long getKeepaliveCountTotal() {
        return this._port.getLifetimeKeepaliveCount();
    }

    @Override
    public long getKeepaliveSelectCountTotal() {
        return this._port.getLifetimeKeepaliveSelectCount();
    }

    @Override
    public long getClientDisconnectCountTotal() {
        return this._port.getLifetimeClientDisconnectCount();
    }

    @Override
    public long getThrottleDisconnectCountTotal() {
        return this._port.getLifetimeThrottleDisconnectCount();
    }

    @Override
    public long getRequestTimeTotal() {
        return this._port.getLifetimeRequestTime();
    }

    @Override
    public long getReadBytesTotal() {
        return this._port.getLifetimeReadBytes();
    }

    @Override
    public long getWriteBytesTotal() {
        return this._port.getLifetimeWriteBytes();
    }

    @Override
    public void start() {
        this._port.enable();
    }

    @Override
    public void stop() {
        this._port.disable();
    }

    @Override
    public TcpConnectionInfo[] connectionInfo() {
        return this._port.getActiveConnections();
    }

    void register() {
        this.registerSelf();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getObjectName() + "]";
    }
}

