/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.inject.Module;
import com.caucho.network.listen.TcpSocketLink;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
enum SocketLinkState {
    INIT{

        @Override
        boolean isAllowIdle() {
            return true;
        }

        @Override
        SocketLinkState toInit(TcpSocketLink conn) {
            return INIT;
        }

        @Override
        SocketLinkState toIdle() {
            return IDLE;
        }

        @Override
        SocketLinkState toAccept() {
            return ACCEPT;
        }
    }
    ,
    ACCEPT{

        @Override
        boolean isActive() {
            return true;
        }

        @Override
        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveAllocate();
            return REQUEST_ACTIVE_KA;
        }

        @Override
        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_NKA;
        }
    }
    ,
    REQUEST_ACTIVE_KA{

        @Override
        boolean isActive() {
            return true;
        }

        @Override
        boolean isRequestActive() {
            return true;
        }

        @Override
        boolean isKeepaliveAllocated() {
            return true;
        }

        @Override
        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        @Override
        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        @Override
        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        @Override
        SocketLinkState toKeepalive(TcpSocketLink conn) {
            return KEEPALIVE_THREAD;
        }

        @Override
        SocketLinkState toComet() {
            return COMET_KA;
        }

        @Override
        SocketLinkState toDuplex(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return DUPLEX;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    REQUEST_ACTIVE_NKA{

        @Override
        boolean isActive() {
            return true;
        }

        @Override
        SocketLinkState toComet() {
            return COMET_NKA;
        }

        @Override
        SocketLinkState toDuplex(TcpSocketLink conn) {
            return DUPLEX;
        }
    }
    ,
    KEEPALIVE_THREAD{

        @Override
        boolean isKeepalive() {
            return true;
        }

        @Override
        boolean isKeepaliveAllocated() {
            return true;
        }

        @Override
        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        @Override
        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        @Override
        SocketLinkState toKeepaliveSelect() {
            return KEEPALIVE_SELECT;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    KEEPALIVE_SELECT{

        @Override
        boolean isKeepalive() {
            return true;
        }

        @Override
        boolean isKeepaliveAllocated() {
            return true;
        }

        @Override
        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        @Override
        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_KA{

        @Override
        boolean isComet() {
            return true;
        }

        @Override
        boolean isCometActive() {
            return true;
        }

        @Override
        boolean isAsyncStarted() {
            return true;
        }

        @Override
        boolean isKeepaliveAllocated() {
            return true;
        }

        @Override
        SocketLinkState toCometSuspend(TcpSocketLink conn) {
            conn.getPort().cometSuspend(conn);
            return COMET_SUSPEND_KA;
        }

        @Override
        SocketLinkState toCometComplete() {
            return COMET_COMPLETE_KA;
        }

        @Override
        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_NKA;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_NKA{

        @Override
        boolean isComet() {
            return true;
        }

        @Override
        boolean isCometActive() {
            return true;
        }

        @Override
        boolean isAsyncStarted() {
            return true;
        }

        @Override
        SocketLinkState toCometSuspend(TcpSocketLink conn) {
            conn.getPort().cometSuspend(conn);
            return COMET_SUSPEND_NKA;
        }

        @Override
        SocketLinkState toCometComplete() {
            return COMET_COMPLETE_NKA;
        }
    }
    ,
    COMET_SUSPEND_KA{

        @Override
        boolean isComet() {
            return true;
        }

        @Override
        boolean isCometSuspend() {
            return true;
        }

        @Override
        boolean isAsyncStarted() {
            return true;
        }

        @Override
        boolean isKeepaliveAllocated() {
            return true;
        }

        @Override
        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_SUSPEND_NKA;
        }

        @Override
        SocketLinkState toCometResume(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            return REQUEST_ACTIVE_KA;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }

        @Override
        SocketLinkState toDestroy(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }
    }
    ,
    COMET_SUSPEND_NKA{

        @Override
        boolean isComet() {
            return true;
        }

        @Override
        boolean isCometSuspend() {
            return true;
        }

        @Override
        boolean isAsyncStarted() {
            return true;
        }

        @Override
        SocketLinkState toCometResume(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            return REQUEST_ACTIVE_NKA;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }

        @Override
        SocketLinkState toDestroy(TcpSocketLink conn) {
            conn.getPort().cometDetach(conn);
            throw new IllegalStateException((Object)((Object)this) + " " + conn);
        }
    }
    ,
    COMET_COMPLETE_KA{

        @Override
        boolean isComet() {
            return true;
        }

        @Override
        boolean isCometComplete() {
            return true;
        }

        @Override
        boolean isKeepaliveAllocated() {
            return true;
        }

        @Override
        SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
            return REQUEST_ACTIVE_KA;
        }

        @Override
        SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return REQUEST_ACTIVE_NKA;
        }

        @Override
        SocketLinkState toKillKeepalive(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return COMET_COMPLETE_NKA;
        }

        @Override
        SocketLinkState toCometComplete() {
            return this;
        }

        @Override
        SocketLinkState toKeepalive(TcpSocketLink conn) {
            return KEEPALIVE_THREAD;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().keepaliveFree();
            return CLOSED;
        }
    }
    ,
    COMET_COMPLETE_NKA{

        @Override
        boolean isComet() {
            return true;
        }

        @Override
        boolean isCometComplete() {
            return true;
        }

        @Override
        SocketLinkState toCometComplete() {
            return this;
        }
    }
    ,
    DUPLEX{

        @Override
        boolean isDuplex() {
            return true;
        }

        @Override
        SocketLinkState toKeepalive(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveBegin();
            return DUPLEX_KEEPALIVE;
        }

        @Override
        SocketLinkState toDuplexActive(TcpSocketLink conn) {
            return DUPLEX;
        }
    }
    ,
    DUPLEX_KEEPALIVE{

        @Override
        boolean isDuplex() {
            return true;
        }

        @Override
        boolean isKeepalive() {
            return true;
        }

        @Override
        SocketLinkState toKeepaliveSelect() {
            return DUPLEX_KEEPALIVE;
        }

        @Override
        SocketLinkState toDuplexActive(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveEnd();
            return DUPLEX;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            conn.getPort().duplexKeepaliveEnd();
            return CLOSED;
        }
    }
    ,
    CLOSED{

        @Override
        boolean isClosed() {
            return true;
        }

        @Override
        boolean isAllowIdle() {
            return true;
        }

        @Override
        SocketLinkState toAccept() {
            return ACCEPT;
        }

        @Override
        SocketLinkState toIdle() {
            return IDLE;
        }
    }
    ,
    IDLE{

        @Override
        boolean isIdle() {
            return true;
        }

        @Override
        SocketLinkState toInit(TcpSocketLink conn) {
            return INIT;
        }

        @Override
        SocketLinkState toAccept() {
            return ACCEPT;
        }

        @Override
        SocketLinkState toFree(TcpSocketLink conn) {
            return this;
        }

        @Override
        SocketLinkState toDestroy(TcpSocketLink conn) {
            throw new IllegalStateException((Object)((Object)this) + " is an illegal destroy state");
        }
    }
    ,
    DESTROYED{

        @Override
        boolean isClosed() {
            return true;
        }

        @Override
        boolean isDestroyed() {
            return true;
        }

        @Override
        SocketLinkState toClosed(TcpSocketLink conn) {
            return this;
        }

        @Override
        SocketLinkState toDestroy(TcpSocketLink conn) {
            return this;
        }
    };

    private static final Logger log;

    boolean isIdle() {
        return false;
    }

    boolean isComet() {
        return false;
    }

    boolean isCometActive() {
        return false;
    }

    boolean isCometSuspend() {
        return false;
    }

    boolean isCometWake() {
        return false;
    }

    boolean isAsyncStarted() {
        return false;
    }

    boolean isCometComplete() {
        return false;
    }

    boolean isDuplex() {
        return false;
    }

    boolean isKeepaliveAllocated() {
        return false;
    }

    boolean isKeepalive() {
        return false;
    }

    boolean isActive() {
        return false;
    }

    boolean isRequestActive() {
        return false;
    }

    boolean isClosed() {
        return false;
    }

    boolean isDestroyed() {
        return false;
    }

    boolean isAllowIdle() {
        return false;
    }

    SocketLinkState toInit(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to init for " + conn);
    }

    SocketLinkState toAccept() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to accept");
    }

    SocketLinkState toActive(TcpSocketLink conn, long connectionStartTime) {
        if (conn.getPort().isKeepaliveAllowed(connectionStartTime)) {
            return this.toActiveWithKeepalive(conn);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(conn + " keepalive disallowed");
        }
        return this.toActiveNoKeepalive(conn);
    }

    SocketLinkState toActiveWithKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to active");
    }

    SocketLinkState toActiveNoKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to active");
    }

    SocketLinkState toKillKeepalive(TcpSocketLink conn) {
        return this;
    }

    SocketLinkState toKeepalive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to keepalive");
    }

    SocketLinkState toKeepaliveSelect() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to keepalive select");
    }

    SocketLinkState toComet() {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to comet");
    }

    SocketLinkState toCometSuspend(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot suspend comet");
    }

    SocketLinkState toCometResume(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot resume comet");
    }

    SocketLinkState toCometDispatch() {
        throw new IllegalStateException((Object)((Object)this) + " cannot dispatch comet");
    }

    SocketLinkState toCometComplete() {
        throw new IllegalStateException((Object)((Object)this) + " cannot complete comet");
    }

    SocketLinkState toDuplex(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to duplex/websocket");
    }

    SocketLinkState toDuplexActive(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " cannot switch to duplex/websocket");
    }

    SocketLinkState toIdle() {
        throw new IllegalStateException((Object)((Object)this) + " is an illegal idle state");
    }

    SocketLinkState toFree(TcpSocketLink conn) {
        throw new IllegalStateException((Object)((Object)this) + " is an illegal free state for " + conn);
    }

    SocketLinkState toClosed(TcpSocketLink conn) {
        return CLOSED;
    }

    SocketLinkState toDestroy(TcpSocketLink conn) {
        this.toClosed(conn);
        conn.getPort().closeConnection(conn);
        return DESTROYED;
    }

    static {
        log = Logger.getLogger(SocketLinkState.class.getName());
    }
}

