/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.network.listen;

import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.network.listen.RequestState;
import com.caucho.network.listen.SocketLinkThreadLauncher;
import com.caucho.network.listen.TcpPort;
import com.caucho.network.listen.TcpSocketLink;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class ConnectionTask
implements Runnable {
    private static final Logger log = Logger.getLogger(ConnectionTask.class.getName());
    private final TcpPort _listener;
    private final TcpSocketLink _socketLink;
    private SocketLinkThreadLauncher _launcher;

    ConnectionTask(TcpSocketLink socketLink) {
        this._socketLink = socketLink;
        this._listener = this._socketLink.getPort();
        this._launcher = this._listener.getLauncher();
    }

    protected final TcpSocketLink getSocketLink() {
        return this._socketLink;
    }

    protected final TcpPort getListener() {
        return this._listener;
    }

    protected final SocketLinkThreadLauncher getLauncher() {
        return this._launcher;
    }

    protected boolean isResumeTask() {
        return false;
    }

    abstract RequestState doTask() throws IOException;

    @Override
    public final void run() {
        SocketLinkThreadLauncher launcher = this.getLauncher();
        boolean isResume = this.isResumeTask();
        try {
            if (isResume) {
                launcher.onChildIdleEnd();
            }
            this.runThread();
        }
        finally {
            if (isResume) {
                launcher.onChildIdleBegin();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runThread() {
        Thread thread = Thread.currentThread();
        RequestState result = RequestState.EXIT;
        this._socketLink.startThread(thread);
        try {
            result = this.doTask();
            if (result != null && result.isAcceptAllowed()) {
                result = this.isResumeTask() ? this._socketLink.handleAcceptTask() : this._socketLink.handleAcceptTaskImpl();
            }
        }
        catch (OutOfMemoryError e) {
            String msg = "TcpSocketLink OutOfMemory";
            ShutdownSystem.shutdownOutOfMemory((String)msg);
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
        finally {
            this._socketLink.finishThread(result);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._socketLink + "]";
    }
}

