/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.MessageBroker;
import com.caucho.message.broker.SenderSettleHandler;
import com.caucho.message.tourmaline.NautilusServerEndpoint;
import com.caucho.vfs.TempBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Logger;

class NautilusPublish
implements SenderSettleHandler {
    private static final Logger log = Logger.getLogger(NautilusPublish.class.getName());
    private NautilusServerEndpoint _endpoint;
    private MessageBroker _broker;
    private String _name;
    private BrokerSender _pub;
    private long _sequence;

    NautilusPublish(NautilusServerEndpoint endpoint) {
        this._endpoint = endpoint;
        this._broker = endpoint.getBroker();
    }

    void add(String key, String value) {
        if ("name".equals(key)) {
            this._name = value;
        }
    }

    void init() {
        if (this._name == null) {
            throw new IllegalStateException("'name' is required");
        }
        Map<String, Object> properties = null;
        this._pub = this._broker.createSender(this._name, properties);
        if (this._pub == null) {
            throw new IllegalStateException(this._name + " is an unknown queue");
        }
    }

    void publish(InputStream is) throws IOException {
        boolean isFinal;
        long xid = 0L;
        long mid = this._pub.nextMessageId();
        boolean isDurable = false;
        int priority = 4;
        long expireTime = 0L;
        TempBuffer tBuf = null;
        do {
            int avail;
            tBuf = (avail = is.available()) <= 256 ? TempBuffer.allocateSmall() : TempBuffer.allocate();
            byte[] buffer = tBuf.getBuffer();
            int len = buffer.length;
            if ((len = is.read(buffer, 0, len)) <= 0) {
                System.out.println("UNExPECTED EOF:");
                return;
            }
            isFinal = is.available() < 0;
            System.out.println("MSG: " + is + " " + isFinal + " " + new String(buffer, 0, len) + " " + this._pub);
            this._pub.message(xid, mid, isDurable, priority, expireTime, buffer, 0, len, tBuf, this);
        } while (!isFinal);
    }

    @Override
    public boolean isSettled() {
        return true;
    }

    @Override
    public void onAccepted(long mid) {
    }

    @Override
    public void onRejected(long mid, String msg) {
    }

    public void close() {
        this._pub.close();
    }
}

