/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.tourmaline;

import com.caucho.message.MessageException;
import com.caucho.message.MessagePropertiesFactory;
import com.caucho.message.tourmaline.AbstractNautilusEndpoint;
import com.caucho.message.tourmaline.NautilusClientSender;
import com.caucho.message.tourmaline.NautilusCode;
import com.caucho.util.IoUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;

class NautilusClientSenderEndpoint<T>
extends AbstractNautilusEndpoint {
    private static final Logger log = Logger.getLogger(NautilusClientSenderEndpoint.class.getName());
    private final NautilusClientSender<T> _sender;

    NautilusClientSenderEndpoint(NautilusClientSender<T> sender) {
        this._sender = sender;
    }

    void sendPublish(String queue) throws IOException {
        OutputStream os = this.getContext().startBinaryMessage();
        try {
            os.write(NautilusCode.PUBLISH.ordinal());
            this.write(os, "name:");
            this.write(os, queue);
            this.write(os, "\n");
        }
        finally {
            IoUtil.close((OutputStream)os);
        }
    }

    void send(MessagePropertiesFactory<T> factory, T value, long timeoutMicros) {
        OutputStream wsOut = null;
        try {
            wsOut = this.getContext().startBinaryMessage();
            wsOut.write(NautilusCode.SEND.ordinal());
            this._sender.getEncoder().encode(wsOut, value);
        }
        catch (IOException e) {
            throw new MessageException(e);
        }
        finally {
            IoUtil.close((OutputStream)wsOut);
        }
    }
}

