/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.stomp;

import com.caucho.message.broker.SenderSettleHandler;
import com.caucho.message.stomp.StompCommand;
import com.caucho.message.stomp.StompConnection;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public class StompNackCommand
extends StompCommand {
    @Override
    boolean doCommand(StompConnection conn, ReadStream is, WriteStream os) throws IOException {
        String subscription = conn.getSubscription();
        long mid = conn.getMessageId();
        SenderSettleHandler listener = conn.createReceiptCallback();
        if (subscription == null) {
            throw new IOException("bad id");
        }
        if (mid <= 0L) {
            throw new IOException("bad mid");
        }
        if (!this.skipToEnd(is)) {
            return false;
        }
        boolean isValid = conn.nack(subscription, mid);
        if (listener != null) {
            if (isValid) {
                listener.onAccepted(mid);
            } else {
                listener.onRejected(mid, "cannot ack from " + subscription);
            }
        }
        return true;
    }
}

