/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.message.nautilus;

import com.caucho.message.journal.JournalRingItem;
import com.caucho.message.nautilus.NautilusBrokerSubscriber;
import com.caucho.message.nautilus.NautilusMultiQueueActor;
import com.caucho.vfs.TempBuffer;

public class NautilusRingItem
extends JournalRingItem {
    public static final int JE_CHECKPOINT = 1;
    public static final int JE_MESSAGE = 2;
    public static final int JE_FLOW = 3;
    public static final int JE_SUBSCRIBE = 4;
    public static final int JE_UNSUBSCRIBE = 5;
    public static final int JE_ACCEPTED = 6;
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private NautilusBrokerSubscriber _subscriber;
    private long _deliveryCount;
    private int _credit;

    NautilusRingItem(int index) {
        super(index);
    }

    public void initAck(long xid, long qid, long mid, NautilusBrokerSubscriber sub) {
        this.init(6L, xid, qid, mid, EMPTY_BUFFER, 0, 0, null);
        this._subscriber = sub;
    }

    public void initSubscribe(long qid, NautilusBrokerSubscriber subscriber) {
        this.init(4L, qid);
        this._subscriber = subscriber;
    }

    public void initUnsubscribe(long qid, NautilusBrokerSubscriber subscriber) {
        this.init(5L, qid);
        this._subscriber = subscriber;
    }

    public void initFlow(long qid, NautilusBrokerSubscriber subscriber, long deliveryCount, int credit) {
        this.init(3L, qid);
        this._subscriber = subscriber;
        this._deliveryCount = deliveryCount;
        this._credit = credit;
    }

    public NautilusBrokerSubscriber getSubscriber() {
        return this._subscriber;
    }

    public long getDeliveryCount() {
        return this._deliveryCount;
    }

    public int getCredit() {
        return this._credit;
    }

    public void clear() {
        this._subscriber = null;
    }

    public void initMessage(long xid, long qid, long mid, boolean isDurable, int priority, long expireTime, byte[] buffer, int offset, int length, TempBuffer tBuf) {
        long code = NautilusMultiQueueActor.encode(2, isDurable, priority, expireTime);
        super.init(code, xid, qid, mid, buffer, offset, length, tBuf);
    }
}

